/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.lang;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetlinks.core.lang.AppendSeparatedCharSequence;
import org.jetlinks.core.lang.AppendSeparatedCharSequenceX;
import org.jetlinks.core.lang.RangeSeparatedCharSequence;
import org.jetlinks.core.lang.ReplacedSeparatedCharSequence;
import org.jetlinks.core.lang.ReplacedSeparatedCharSequence2;
import org.jetlinks.core.lang.ReplacedSeparatedCharSequence3;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SeparatedString;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.StringBuilderUtils;

abstract class AbstractSeparatedCharSequence
implements SeparatedCharSequence {
    private int $hash;

    AbstractSeparatedCharSequence() {
    }

    @Override
    public abstract char separator();

    @Override
    public abstract int size();

    @Override
    public abstract CharSequence get(int var1);

    @Override
    public SeparatedCharSequence replace(int index, CharSequence newChar) {
        return new ReplacedSeparatedCharSequence(this, index, newChar);
    }

    public SeparatedCharSequence replace(int i0, CharSequence r0, int i1, CharSequence r1) {
        return new ReplacedSeparatedCharSequence2(this, i0, r0, i1, r1);
    }

    public SeparatedCharSequence replace(int i0, CharSequence r0, int i1, CharSequence r1, int i2, CharSequence r2) {
        return new ReplacedSeparatedCharSequence3(this, i0, r0, i1, r1, i2, r2);
    }

    @Override
    public AbstractSeparatedCharSequence append(CharSequence ... csq) {
        if (csq == null || csq.length == 0) {
            return this;
        }
        if (csq.length == 1) {
            return this.append(csq[0]);
        }
        if (csq.length == 2) {
            return this.append(csq[0]).append(csq[1]);
        }
        if (csq.length == 3) {
            return this.append(csq[0]).append(csq[1]).append(csq[2]);
        }
        AbstractSeparatedCharSequence s = this;
        for (CharSequence charSequence : csq) {
            s = s.append(charSequence);
        }
        return s;
    }

    @Override
    public AbstractSeparatedCharSequence append(CharSequence csq) {
        if (!(csq instanceof SeparatedCharSequence)) {
            csq = SeparatedString.of(this.separator(), csq.toString());
        }
        if (csq instanceof SeparatedCharSequence) {
            return new AppendSeparatedCharSequenceX(this, (SeparatedCharSequence)csq);
        }
        if (csq.length() > 0 && csq.charAt(0) == this.separator()) {
            csq = csq.subSequence(0, csq.length());
        }
        return new AppendSeparatedCharSequence(this, csq);
    }

    @Override
    public SeparatedCharSequence append(char c) {
        if (c == this.separator()) {
            return new AppendSeparatedCharSequence(this, "");
        }
        return this.append((CharSequence)String.valueOf(c));
    }

    @Override
    public SeparatedCharSequence append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public SeparatedCharSequence range(int start, int end) {
        return new RangeSeparatedCharSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        int anotherSize;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSeparatedCharSequence another = (AbstractSeparatedCharSequence)obj;
        if (another.separator() != this.separator()) {
            return false;
        }
        int size = this.size();
        if (size != (anotherSize = another.size())) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects.equals(this.get(i), another.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.$hash;
        if (h == 0) {
            h = this.getClass().hashCode();
            int size = this.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    h = 31 * h + this.get(i).hashCode() + this.separator();
                }
            }
        }
        this.$hash = h;
        return this.$hash;
    }

    @Override
    public int compareTo(@Nonnull SeparatedCharSequence c) {
        int targetSize;
        int selfSize;
        if (this == c) {
            return 0;
        }
        if (c instanceof AbstractSeparatedCharSequence) {
            AbstractSeparatedCharSequence o = (AbstractSeparatedCharSequence)c;
            if (this.separator() != o.separator()) {
                return Character.compare(this.separator(), o.separator());
            }
        }
        if ((selfSize = this.size()) != (targetSize = c.size())) {
            return Integer.compare(selfSize, targetSize);
        }
        int r = 0;
        for (int i = 0; i < selfSize; ++i) {
            CharSequence selfElement = this.get(i);
            CharSequence targetElement = c.get(i);
            if (selfElement == null || targetElement == null) {
                r = Objects.equals(selfElement, targetElement) ? 1 : 0;
            } else if (selfElement instanceof String && targetElement instanceof String) {
                if (selfElement != targetElement) {
                    r = ((String)selfElement).compareTo((String)targetElement);
                }
            } else {
                r = selfElement instanceof Comparable && selfElement.getClass() == targetElement.getClass() ? ((Comparable)((Object)selfElement)).compareTo(targetElement) : this.compare(selfElement, targetElement);
            }
            if (r == 0) continue;
            return r;
        }
        return r;
    }

    @Override
    private int compare(CharSequence a, CharSequence b) {
        int len1 = a.length();
        int len2 = b.length();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = a.charAt(k);
            if (c1 == (c2 = b.charAt(k))) continue;
            return Character.compare(c1, c2);
        }
        return Integer.compare(len1, len2);
    }

    @Override
    public int length() {
        int len = 0;
        for (int i = 0; i < this.size(); ++i) {
            len += this.get(i).length();
            ++len;
        }
        return len - 1;
    }

    @Override
    public char charAt(int index) {
        int size = this.size();
        int c = 0;
        for (int i = 0; i < size; ++i) {
            CharSequence element = this.get(i);
            int len = element.length();
            int target = c + len;
            if (index < target) {
                return element.charAt(index - c);
            }
            if (index == target) {
                return this.separator();
            }
            c += len + 1;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    @Nonnull
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    @Nonnull
    public String toString() {
        return StringBuilderUtils.buildString(this, (self, sb) -> {
            char sp = self.separator();
            int index = 0;
            int size = self.size();
            for (int i = index; i < size; ++i) {
                if (i > index) {
                    sb.append(sp);
                }
                sb.append(self.get(i));
            }
        });
    }

    @Override
    public AbstractSeparatedCharSequence intern() {
        return RecyclerUtils.intern(this);
    }
}

