/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device.manager;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.jetlinks.core.device.manager.BindInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeviceBindManager {
    default public Mono<Void> bind(@Nonnull String type, @Nonnull String key, @Nonnull String deviceId) {
        return this.bind(type, key, deviceId, null);
    }

    public Mono<Void> bind(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, String var4);

    default public Mono<Void> bindBatch(@Nonnull String type, Collection<BindInfo> bindInfos) {
        return Flux.fromIterable(bindInfos).flatMap(bindInfo -> this.bind(type, bindInfo.getKey(), bindInfo.getDeviceId(), bindInfo.getDescription())).then();
    }

    public Mono<Void> unbind(@Nonnull String var1, @Nonnull String var2);

    public Mono<Void> unbindByDevice(@Nonnull String var1, @Nonnull Collection<String> var2);

    public Mono<BindInfo> getBindInfo(@Nonnull String var1, @Nonnull String var2);

    default public Mono<BindInfo> getBindInfoByDeviceId(@Nonnull String type, @Nonnull String deviceId) {
        return Mono.error((Throwable)new UnsupportedOperationException());
    }

    default public Flux<BindInfo> getBindInfoByDeviceId(@Nonnull String type, @Nonnull Collection<String> deviceId) {
        return Flux.error((Throwable)new UnsupportedOperationException());
    }

    public Flux<BindInfo> getBindInfo(@Nonnull String var1, @Nonnull Collection<String> var2);

    public Flux<BindInfo> getBindInfo(@Nonnull String var1);
}

