/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingInfo;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingTemplateInfo;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.things.ThingsRegistry;
import org.jetlinks.core.things.ThingsRegistrySupport;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public class MultiThingsRegistrySupport
implements ThingsRegistrySupport {
    private final Map<String, ThingsRegistrySupport> supports = new ConcurrentHashMap<String, ThingsRegistrySupport>();

    public void addSupport(ThingType type, ThingsRegistrySupport support) {
        this.supports.put(type.getId(), support);
    }

    public void removeSupport(ThingType type) {
        this.supports.remove(type.getId());
    }

    protected ThingsRegistrySupport supportNotFound(String thingType) {
        throw new UnsupportedOperationException("unsupported thing type " + thingType);
    }

    private <T, ARG> Mono<T> doWith(String thingType, ARG arg, Function3<ThingsRegistrySupport, String, ARG, Mono<T>> executor) {
        ThingsRegistrySupport support = this.supports.get(thingType);
        if (support == null) {
            support = this.supportNotFound(thingType);
        }
        return (Mono)executor.apply((Object)support, (Object)thingType, arg);
    }

    @Override
    public final Mono<Thing> getThing(@Nonnull String thingType, @Nonnull String thingId) {
        return this.doWith(thingType, thingId, ThingsRegistry::getThing);
    }

    @Override
    public final Mono<ThingTemplate> getTemplate(@Nonnull String thingType, @Nonnull String templateId) {
        return this.doWith(thingType, templateId, ThingsRegistry::getTemplate);
    }

    @Override
    public final Mono<Thing> register(@Nonnull String thingType, @Nonnull ThingInfo info) {
        return this.doWith(thingType, info, ThingsRegistry::register);
    }

    @Override
    public final Mono<Void> unregisterThing(@Nonnull String thingType, @Nonnull String thingId) {
        return this.doWith(thingType, thingId, ThingsRegistry::unregisterThing);
    }

    @Override
    public final Mono<ThingTemplate> register(@Nonnull String thingType, @Nonnull ThingTemplateInfo templateInfo) {
        return this.doWith(thingType, templateInfo, ThingsRegistry::register);
    }

    @Override
    public final Mono<Void> unregisterTemplate(@Nonnull String thingType, @Nonnull String templateId) {
        return this.doWith(thingType, templateId, ThingsRegistry::unregisterTemplate);
    }

    @Override
    public boolean isSupported(String thingType) {
        return this.supports.containsKey(thingType);
    }
}

