/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.FunctionMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ContextWriteCommandSupport
implements CommandSupport {
    private final CommandSupport origin;
    private final Mono<Context> contextMono;

    @Override
    public boolean isWrapperFor(Class<?> type) {
        return this.origin.isWrapperFor(type);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return this.origin.unwrap(type);
    }

    @Override
    @Nonnull
    public <R> R execute(@Nonnull Command<R> command) {
        if (CommandUtils.commandResponseFlux(command)) {
            return (R)this.contextMono.flatMapMany(ctx -> this.origin.executeToFlux(command).contextWrite((ContextView)ctx));
        }
        if (CommandUtils.commandResponseMono(command)) {
            return (R)this.contextMono.flatMap(ctx -> this.origin.executeToMono(command).contextWrite((ContextView)ctx));
        }
        return this.origin.execute(command);
    }

    @Override
    public Flux<Object> executeToFlux(Command<?> command) {
        return this.contextMono.flatMapMany(ctx -> this.origin.executeToFlux(command).contextWrite((ContextView)ctx));
    }

    @Override
    public Flux<Object> executeToFlux(String commandId, Map<String, Object> parameters) {
        return this.contextMono.flatMapMany(ctx -> this.origin.executeToFlux(commandId, parameters).contextWrite((ContextView)ctx));
    }

    @Override
    public Flux<Object> executeToFlux(String commandId, Map<String, Object> parameters, Flux<Object> stream) {
        return this.contextMono.flatMapMany(ctx -> this.origin.executeToFlux(commandId, parameters, stream).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<Object> executeToMono(Command<?> command) {
        return this.contextMono.flatMap(ctx -> this.origin.executeToMono(command).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<Object> executeToMono(String commandId, Map<String, Object> parameters) {
        return this.contextMono.flatMap(ctx -> this.origin.executeToMono(commandId, parameters).contextWrite((ContextView)ctx));
    }

    @Override
    public <R, C extends Command<R>> C createCommand(String commandId) {
        return this.origin.createCommand(commandId);
    }

    @Override
    public <R, C extends Command<R>> Mono<C> createCommandAsync(String commandId) {
        return this.contextMono.flatMap(ctx -> this.origin.createCommandAsync(commandId).contextWrite((ContextView)ctx));
    }

    @Override
    public Flux<FunctionMetadata> getCommandMetadata() {
        return this.contextMono.flatMapMany(ctx -> this.origin.getCommandMetadata().contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(String commandId) {
        return this.contextMono.flatMap(ctx -> this.origin.getCommandMetadata(commandId).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(Command<?> command) {
        return this.contextMono.flatMap(ctx -> this.origin.getCommandMetadata(command).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(@Nonnull String commandId, @Nullable Map<String, Object> parameters) {
        return this.contextMono.flatMap(ctx -> this.origin.getCommandMetadata(commandId, parameters).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<Boolean> commandIsSupported(Command<?> cmd) {
        return this.contextMono.flatMap(ctx -> this.origin.commandIsSupported(cmd).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<Boolean> commandIsSupported(Class<? extends Command<?>> cmd) {
        return this.contextMono.flatMap(ctx -> this.origin.commandIsSupported(cmd).contextWrite((ContextView)ctx));
    }

    @Override
    public Mono<Boolean> commandIsSupported(String commandId) {
        return this.contextMono.flatMap(ctx -> this.origin.commandIsSupported(commandId).contextWrite((ContextView)ctx));
    }

    public ContextWriteCommandSupport(CommandSupport origin, Mono<Context> contextMono) {
        this.origin = origin;
        this.contextMono = contextMono;
    }
}

