/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.FunctionMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncProxyCommandSupport
implements CommandSupport {
    private final Mono<CommandSupport> asyncCommand;

    @Override
    @Nonnull
    public <R> R execute(@Nonnull Command<R> command) {
        if (command instanceof ProxyCommand) {
            return (R)this.executeToFlux(command);
        }
        if (CommandUtils.commandResponseMono(command)) {
            return (R)this.executeToMono(command);
        }
        return (R)this.executeToFlux(command);
    }

    @Override
    public final Flux<Object> executeToFlux(Command<?> command) {
        if (command instanceof ProxyCommand) {
            ProxyCommand cmd = (ProxyCommand)command;
            return this.asyncCommand.flatMapMany(support -> support.createCommandAsync(cmd.getCommandId()).doOnNext(proxyCmd -> proxyCmd.with(cmd.readable())).flatMapMany(support::executeToFlux));
        }
        return this.asyncCommand.flatMapMany(support -> support.executeToFlux(command));
    }

    @Override
    public final Mono<Object> executeToMono(Command<?> command) {
        if (command instanceof ProxyCommand) {
            ProxyCommand cmd = (ProxyCommand)command;
            return this.asyncCommand.flatMap(support -> support.createCommandAsync(cmd.getCommandId()).doOnNext(proxyCmd -> proxyCmd.with(cmd.readable())).flatMap(support::executeToMono));
        }
        return this.asyncCommand.flatMap(support -> support.executeToMono(command));
    }

    @Override
    public final <R, C extends Command<R>> C createCommand(String commandId) {
        return (C)ProxyCommand.of(commandId);
    }

    @Override
    public final <R, C extends Command<R>> Mono<C> createCommandAsync(String commandId) {
        return this.asyncCommand.flatMap(s -> s.createCommandAsync(commandId));
    }

    @Override
    public final Flux<FunctionMetadata> getCommandMetadata() {
        return this.asyncCommand.flatMapMany(CommandSupport::getCommandMetadata);
    }

    @Override
    public final Mono<FunctionMetadata> getCommandMetadata(String commandId) {
        return this.asyncCommand.flatMap(s -> s.getCommandMetadata(commandId));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(Command<?> command) {
        return this.asyncCommand.flatMap(s -> s.getCommandMetadata(command));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(@Nonnull String commandId, @Nullable Map<String, Object> parameters) {
        return this.asyncCommand.flatMap(s -> s.getCommandMetadata(commandId, parameters));
    }

    @Override
    public Mono<Boolean> commandIsSupported(String commandId) {
        return this.asyncCommand.flatMap(s -> s.commandIsSupported(commandId));
    }

    @Override
    public Mono<Boolean> commandIsSupported(Command<?> cmd) {
        return this.asyncCommand.flatMap(s -> s.commandIsSupported(cmd));
    }

    @Override
    public Mono<Boolean> commandIsSupported(Class<? extends Command<?>> cmd) {
        return this.asyncCommand.flatMap(s -> s.commandIsSupported(cmd));
    }

    public AsyncProxyCommandSupport(Mono<CommandSupport> asyncCommand) {
        this.asyncCommand = asyncCommand;
    }

    public static class ProxyCommand
    extends AbstractCommand<Object, ProxyCommand> {
        private String commandId;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.commandId);
            super.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.commandId = in.readUTF();
            super.readExternal(in);
        }

        private ProxyCommand(String commandId) {
            this.commandId = commandId;
        }

        public static ProxyCommand of(String commandId) {
            return new ProxyCommand(commandId);
        }

        public ProxyCommand() {
        }

        @Override
        public String getCommandId() {
            return this.commandId;
        }
    }
}

