/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import reactor.function.Function3;

public class ErrorCodec
implements Codec<Throwable> {
    public static ErrorCodec RUNTIME;
    public static ErrorCodec DEFAULT;
    private final Function3<String, String, String, Throwable> mapping;

    public static ErrorCodec of(Function<String, Throwable> mapping) {
        return new ErrorCodec((Function3<String, String, String, Throwable>)((Function3)(type, msg, stack) -> (Throwable)mapping.apply((String)msg)));
    }

    public static ErrorCodec of(Function3<String, String, String, Throwable> mapping) {
        return new ErrorCodec(mapping);
    }

    @Override
    public Class<Throwable> forType() {
        return Throwable.class;
    }

    @Override
    public Throwable decode(@Nonnull Payload payload) {
        String body = payload.bodyToString(false);
        if (body.startsWith("{")) {
            JSONObject json = JSON.parseObject((String)body);
            return (Throwable)this.mapping.apply((Object)json.getString("t"), (Object)json.getString("m"), (Object)json.getString("s"));
        }
        return (Throwable)this.mapping.apply(null, (Object)body, null);
    }

    @Override
    public Payload encode(Throwable body) {
        JSONObject state = new JSONObject();
        state.put("m", (Object)body.getMessage());
        state.put("t", (Object)body.getClass().getName());
        state.put("s", (Object)StringUtils.throwable2String((Throwable)body));
        return Payload.of(state.toJSONString());
    }

    private ErrorCodec(Function3<String, String, String, Throwable> mapping) {
        this.mapping = mapping;
    }

    static {
        DEFAULT = RUNTIME = ErrorCodec.of((Function3<String, String, String, Throwable>)((Function3)(type, msg, stack) -> stack == null ? new RuntimeException((String)msg) : new RuntimeException((String)stack)));
    }
}

