/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;
import reactor.core.publisher.Mono;

public interface Configurable {
    public Mono<Value> getConfig(String var1);

    public Mono<Values> getConfigs(Collection<String> var1);

    public Mono<Boolean> setConfig(String var1, Object var2);

    default public Mono<Boolean> setConfig(ConfigKeyValue<?> keyValue) {
        return this.setConfig(keyValue.getKey(), keyValue.getValue());
    }

    default public <T> Mono<Boolean> setConfig(ConfigKey<T> key, T value) {
        return this.setConfig(key.getKey(), value);
    }

    default public Mono<Boolean> setConfigs(ConfigKeyValue<?> ... keyValues) {
        return this.setConfigs(Arrays.stream(keyValues).filter(ConfigKeyValue::isNotNull).collect(Collectors.toMap(ConfigKey::getKey, ConfigKeyValue::getValue)));
    }

    default public <V> Mono<V> getConfig(ConfigKey<V> key) {
        return this.getConfig(key.getKey()).mapNotNull(v -> v.as(key.getValueType()));
    }

    default public Mono<Values> getConfigs(ConfigKey<?> ... key) {
        HashSet keys = Sets.newHashSetWithExpectedSize((int)key.length);
        for (ConfigKey<?> configKey : key) {
            keys.add(configKey.getKey());
        }
        return this.getConfigs(keys);
    }

    default public Mono<Values> getConfigs(String ... keys) {
        return this.getConfigs(Sets.newHashSet((Object[])keys));
    }

    public Mono<Boolean> setConfigs(Map<String, Object> var1);

    public Mono<Boolean> removeConfig(String var1);

    public Mono<Value> getAndRemoveConfig(String var1);

    public Mono<Boolean> removeConfigs(Collection<String> var1);

    public Mono<Void> refreshConfig(Collection<String> var1);

    public Mono<Void> refreshAllConfig();

    default public Mono<Boolean> removeConfigs(ConfigKey<?> ... key) {
        return this.removeConfigs(Arrays.stream(key).map(ConfigKey::getKey).collect(Collectors.toSet()));
    }
}

