/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XCFrameworkTaskKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0007J&\u0010)\u001a\u00020(2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u001f\u0010+\u001a\u00020(2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050,\"\u00020\u0005\u00a2\u0006\u0002\u0010-R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u00020\u00138GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00138EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015R\u0014\u0010%\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\t\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/XCFrameworkTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allFrameworks", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "baseName", "", "getBaseName", "()Ljava/lang/String;", "setBaseName", "(Ljava/lang/String;)V", "buildType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getBuildType", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "setBuildType", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;)V", "fatFrameworksDir", "Ljava/io/File;", "getFatFrameworksDir", "()Ljava/io/File;", "frameworks", "", "getFrameworks", "()Ljava/util/List;", "inputFrameworkFiles", "", "Lorg/gradle/api/file/FileTree;", "getInputFrameworkFiles", "()Ljava/lang/Iterable;", "outputDir", "getOutputDir", "setOutputDir", "(Ljava/io/File;)V", "outputXCFrameworkFile", "getOutputXCFrameworkFile", "xcFrameworkName", "getXcFrameworkName", "assemble", "", "createXCFramework", "output", "from", "", "([Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)V", "kotlin-gradle-plugin"})
public abstract class XCFrameworkTask
extends DefaultTask {
    @Input
    @NotNull
    private String baseName;
    @Input
    @NotNull
    private NativeBuildType buildType;
    @NotNull
    private final Set<Framework> allFrameworks;
    @NotNull
    private File outputDir;

    public XCFrameworkTask() {
        String string = this.getProject().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        this.baseName = string;
        this.buildType = NativeBuildType.RELEASE;
        boolean bl = false;
        this.allFrameworks = new LinkedHashSet();
        File file = this.getProject().getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        this.outputDir = FilesKt.resolve((File)file, (String)"XCFrameworks");
    }

    @NotNull
    public final String getBaseName() {
        return this.baseName;
    }

    public final void setBaseName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.baseName = string;
    }

    private final String getXcFrameworkName() {
        return KotlinCocoapodsPluginKt.asValidFrameworkName(this.baseName);
    }

    @NotNull
    public final NativeBuildType getBuildType() {
        return this.buildType;
    }

    public final void setBuildType(@NotNull NativeBuildType nativeBuildType) {
        Intrinsics.checkParameterIsNotNull((Object)nativeBuildType, (String)"<set-?>");
        this.buildType = nativeBuildType;
    }

    /*
     * WARNING - void declaration
     */
    @Internal
    @NotNull
    public final List<Framework> getFrameworks() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.allFrameworks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Framework it = (Framework)element$iv$iv;
            boolean bl = false;
            if (!(it.getBuildType() == this.getBuildType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @SkipWhenEmpty
    @NotNull
    protected final Iterable<FileTree> getInputFrameworkFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getFrameworks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Framework framework2 = (Framework)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)it.getOutputFile());
            collection.add(configurableFileTree);
        }
        return (List)destination$iv$iv;
    }

    @Internal
    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @Internal
    @NotNull
    protected final File getFatFrameworksDir() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return XCFrameworkTaskKt.access$fatFrameworkDir(project, this.getXcFrameworkName(), this.buildType);
    }

    @OutputDirectory
    @NotNull
    protected final File getOutputXCFrameworkFile() {
        return FilesKt.resolve((File)FilesKt.resolve((File)this.outputDir, (String)this.buildType.getName()), (String)Intrinsics.stringPlus((String)this.getXcFrameworkName(), (Object)".xcframework"));
    }

    public final void from(Framework ... frameworks) {
        Intrinsics.checkParameterIsNotNull((Object)frameworks, (String)"frameworks");
        Framework[] $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        Framework[] frameworkArray = $this$forEach$iv;
        int n = frameworkArray.length;
        for (int j = 0; j < n; ++j) {
            Framework element$iv;
            Framework framework2 = element$iv = frameworkArray[j];
            boolean bl = false;
            boolean bl2 = framework2.getKonanTarget$kotlin_gradle_plugin().getFamily().isAppleFamily();
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "XCFramework supports Apple frameworks only";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.allFrameworks.add(framework2);
            Object[] objectArray = new Object[]{framework2.getLinkTask()};
            this.dependsOn(objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void assemble() {
        void $this$mapNotNullTo$iv$iv;
        AppleTarget[] $this$mapNotNull$iv = AppleTarget.values();
        boolean $i$f$mapNotNull = false;
        AppleTarget[] appleTargetArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_8 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_8).length;
        for (int j = 0; j < n; ++j) {
            File file;
            void $this$filterTo$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_8[j];
            boolean bl = false;
            void appleTarget = element$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = this.getFrameworks();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Framework it = (Framework)element$iv$iv2;
                boolean bl3 = false;
                if (!appleTarget.getTargets().contains(it.getKonanTarget$kotlin_gradle_plugin())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List group2 = (List)destination$iv$iv2;
            if ((group2.size() == 1 ? ((Framework)CollectionsKt.first((List)group2)).getOutputFile() : (group2.size() > 1 ? FilesKt.resolve((File)FilesKt.resolve((File)this.getFatFrameworksDir(), (String)appleTarget.getTargetName()), (String)Intrinsics.stringPlus((String)this.getXcFrameworkName(), (Object)".framework")) : null)) == null) continue;
            file = file;
            boolean bl4 = false;
            boolean bl5 = false;
            File it$iv$iv = file;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List frameworksForXCFramework = (List)destination$iv$iv;
        this.createXCFramework(frameworksForXCFramework, this.getOutputXCFrameworkFile(), this.buildType);
    }

    private final void createXCFramework(List<? extends File> frameworks, File output2, NativeBuildType buildType) {
        if (output2.exists()) {
            FilesKt.deleteRecursively((File)output2);
        }
        Object object = new String[]{"xcodebuild", "-create-xcframework"};
        List cmdArgs = CollectionsKt.mutableListOf((Object[])object);
        Iterable $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File framework2 = (File)element$iv;
            boolean bl = false;
            cmdArgs.add("-framework");
            String string = framework2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"framework.path");
            cmdArgs.add(string);
            if (buildType != NativeBuildType.DEBUG) continue;
            cmdArgs.add("-debug-symbols");
            cmdArgs.add(Intrinsics.stringPlus((String)framework2.getPath(), (Object)".dSYM"));
        }
        cmdArgs.add("-output");
        object = output2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"output.path");
        cmdArgs.add(object);
        this.getProject().exec(new Action(cmdArgs){
            final /* synthetic */ List<String> $cmdArgs;
            {
                this.$cmdArgs = $cmdArgs;
            }

            public final void execute(ExecSpec it) {
                it.commandLine((Iterable)this.$cmdArgs);
            }
        });
    }
}

