/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.EntityManager;
import org.hswebframework.ezorm.rdb.mapping.MappingFeatureType;
import org.hswebframework.ezorm.rdb.mapping.jpa.JpaEntityTableMetadataParser;
import org.hswebframework.ezorm.rdb.mapping.jpa.JpaEntityTableMetadataParserProcessor;
import org.hswebframework.ezorm.rdb.mapping.parser.EntityTableMetadataParser;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBDatabaseMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.DefaultDatabaseOperator;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.crud.annotation.EnableEasyormRepository;
import org.hswebframework.web.crud.configuration.CompositeEntityTableMetadataResolver;
import org.hswebframework.web.crud.configuration.DefaultEntityResultWrapperFactory;
import org.hswebframework.web.crud.configuration.DetectEntityColumnMapping;
import org.hswebframework.web.crud.configuration.EasyormProperties;
import org.hswebframework.web.crud.configuration.EntityTableMetadataResolver;
import org.hswebframework.web.crud.configuration.TableMetadataCustomizer;
import org.hswebframework.web.crud.entity.factory.EntityMappingCustomizer;
import org.hswebframework.web.crud.entity.factory.MapperEntityFactory;
import org.hswebframework.web.crud.events.CompositeEventListener;
import org.hswebframework.web.crud.events.CreatorEventListener;
import org.hswebframework.web.crud.events.DefaultEntityEventListenerConfigure;
import org.hswebframework.web.crud.events.EntityEventListener;
import org.hswebframework.web.crud.events.EntityEventListenerCustomizer;
import org.hswebframework.web.crud.events.SqlExpressionInvoker;
import org.hswebframework.web.crud.events.ValidateEventListener;
import org.hswebframework.web.crud.events.expr.SpelSqlExpressionInvoker;
import org.hswebframework.web.crud.generator.CurrentTimeGenerator;
import org.hswebframework.web.crud.generator.DefaultIdGenerator;
import org.hswebframework.web.crud.generator.MD5Generator;
import org.hswebframework.web.crud.generator.RandomIdGenerator;
import org.hswebframework.web.crud.generator.SnowFlakeStringIdGenerator;
import org.hswebframework.web.crud.query.DefaultQueryHelper;
import org.hswebframework.web.crud.query.QueryHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@EnableConfigurationProperties(value={EasyormProperties.class})
@EnableEasyormRepository(value={"org.hswebframework.web.**.entity"})
public class EasyormConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public EntityFactory entityFactory(ObjectProvider<EntityMappingCustomizer> customizers) {
        MapperEntityFactory factory = new MapperEntityFactory();
        for (EntityMappingCustomizer customizer : customizers) {
            customizer.custom(factory);
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public RDBDatabaseMetadata databaseMetadata(Optional<SyncSqlExecutor> syncSqlExecutor, Optional<ReactiveSqlExecutor> reactiveSqlExecutor, EasyormProperties properties) {
        RDBDatabaseMetadata metadata = properties.createDatabaseMetadata();
        syncSqlExecutor.ifPresent(arg_0 -> ((RDBDatabaseMetadata)metadata).addFeature(arg_0));
        reactiveSqlExecutor.ifPresent(arg_0 -> ((RDBDatabaseMetadata)metadata).addFeature(arg_0));
        if (properties.isAutoDdl() && reactiveSqlExecutor.isPresent()) {
            for (RDBSchemaMetadata schema : metadata.getSchemas()) {
                schema.loadAllTableReactive().block(Duration.ofSeconds(30L));
            }
        }
        return metadata;
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseOperator databaseOperator(RDBDatabaseMetadata metadata) {
        return DefaultDatabaseOperator.of((RDBDatabaseMetadata)metadata);
    }

    @Bean
    public QueryHelper queryHelper(DatabaseOperator databaseOperator) {
        return new DefaultQueryHelper(databaseOperator);
    }

    @Bean
    public BeanPostProcessor autoRegisterFeature(final RDBDatabaseMetadata metadata) {
        final CompositeEventListener eventListener = new CompositeEventListener();
        metadata.addFeature((Feature)eventListener);
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof EventListener) {
                    eventListener.addListener((EventListener)bean);
                } else if (bean instanceof Feature) {
                    metadata.addFeature((Feature)bean);
                }
                return bean;
            }
        };
    }

    @Bean
    public CreatorEventListener creatorEventListener() {
        return new CreatorEventListener();
    }

    @Bean
    public ValidateEventListener validateEventListener() {
        return new ValidateEventListener();
    }

    @Bean
    public EntityEventListener entityEventListener(ApplicationEventPublisher eventPublisher, ObjectProvider<SqlExpressionInvoker> invokers, ObjectProvider<EntityEventListenerCustomizer> customizers) {
        DefaultEntityEventListenerConfigure configure = new DefaultEntityEventListenerConfigure();
        customizers.forEach(customizer -> customizer.customize(configure));
        EntityEventListener entityEventListener = new EntityEventListener(eventPublisher, configure);
        entityEventListener.setExpressionInvoker((SqlExpressionInvoker)invokers.getIfAvailable(SpelSqlExpressionInvoker::new));
        return entityEventListener;
    }

    @Bean
    @ConfigurationProperties(prefix="easyorm.default-value-generator")
    public DefaultIdGenerator defaultIdGenerator() {
        return new DefaultIdGenerator();
    }

    @Bean
    public MD5Generator md5Generator() {
        return new MD5Generator();
    }

    @Bean
    public SnowFlakeStringIdGenerator snowFlakeStringIdGenerator() {
        return new SnowFlakeStringIdGenerator();
    }

    @Bean
    public RandomIdGenerator randomIdGenerator() {
        return new RandomIdGenerator();
    }

    @Bean
    public CurrentTimeGenerator currentTimeGenerator() {
        return new CurrentTimeGenerator();
    }

    @Configuration
    public static class EntityTableMetadataParserConfiguration {
        @Bean
        public DefaultEntityResultWrapperFactory defaultEntityResultWrapperFactory(EntityManager entityManager) {
            return new DefaultEntityResultWrapperFactory(entityManager);
        }

        @Bean
        @ConditionalOnMissingBean
        public EntityManager entityManager(final EntityTableMetadataResolver resolver, final EntityFactory entityFactory) {
            return new EntityManager(){

                public <E> E newInstance(Class<E> type) {
                    return (E)entityFactory.newInstance(type);
                }

                public EntityColumnMapping getMapping(Class entity) {
                    return resolver.resolve(entity).getFeature(MappingFeatureType.columnPropertyMapping.createFeatureId(entity)).map(EntityColumnMapping.class::cast).orElse(null);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        public EntityTableMetadataResolver entityTableMappingResolver(ObjectProvider<EntityTableMetadataParser> parsers) {
            CompositeEntityTableMetadataResolver resolver = new CompositeEntityTableMetadataResolver();
            parsers.forEach(resolver::addParser);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean
        public EntityTableMetadataParser jpaEntityTableMetadataParser(RDBDatabaseMetadata metadata, final EntityFactory factory, final ObjectProvider<TableMetadataCustomizer> customizers) {
            JpaEntityTableMetadataParser parser = new JpaEntityTableMetadataParser(){

                public Optional<RDBTableMetadata> parseTableMetadata(Class<?> entityType) {
                    Class realType = factory.getInstanceType(entityType, true);
                    Optional tableOpt = super.parseTableMetadata(realType);
                    tableOpt.ifPresent(table -> {
                        EntityColumnMapping columnMapping = (EntityColumnMapping)table.findFeatureNow(MappingFeatureType.columnPropertyMapping.createFeatureId(realType));
                        if (realType != entityType) {
                            table.addFeature((Feature)new DetectEntityColumnMapping(realType, columnMapping, factory));
                            columnMapping = new DetectEntityColumnMapping(entityType, columnMapping, factory);
                            table.addFeature((Feature)columnMapping);
                        }
                        for (TableMetadataCustomizer customizer : customizers) {
                            customizer.customTable(realType, (RDBTableMetadata)table);
                        }
                        columnMapping.reload();
                    });
                    return tableOpt;
                }

                protected JpaEntityTableMetadataParserProcessor createProcessor(RDBTableMetadata table, Class<?> type) {
                    final Class realType = factory.getInstanceType(type, true);
                    return new JpaEntityTableMetadataParserProcessor(table, realType){

                        protected void customColumn(PropertyDescriptor descriptor, Field field, RDBColumnMetadata column, Set<Annotation> annotations) {
                            super.customColumn(descriptor, field, column, annotations);
                            for (TableMetadataCustomizer customizer : customizers) {
                                customizer.customColumn(realType, descriptor, field, annotations, column);
                            }
                        }
                    };
                }
            };
            parser.setDatabaseMetadata(metadata);
            return parser;
        }
    }
}

