/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple.builder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.Role;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.builder.AuthenticationBuilder;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import org.hswebframework.web.authorization.simple.SimpleDimension;
import org.hswebframework.web.authorization.simple.SimpleDimensionType;
import org.hswebframework.web.authorization.simple.SimplePermission;
import org.hswebframework.web.authorization.simple.SimpleRole;
import org.hswebframework.web.authorization.simple.SimpleUser;

public class SimpleAuthenticationBuilder
implements AuthenticationBuilder {
    private SimpleAuthentication authentication = new SimpleAuthentication();
    private DataAccessConfigBuilderFactory dataBuilderFactory;

    public SimpleAuthenticationBuilder(DataAccessConfigBuilderFactory dataBuilderFactory) {
        this.dataBuilderFactory = dataBuilderFactory;
    }

    public void setDataBuilderFactory(DataAccessConfigBuilderFactory dataBuilderFactory) {
        this.dataBuilderFactory = dataBuilderFactory;
    }

    @Override
    public AuthenticationBuilder user(User user) {
        Objects.requireNonNull(user);
        this.authentication.setUser(user);
        return this;
    }

    @Override
    public AuthenticationBuilder user(String user) {
        return this.user((User)JSON.parseObject((String)user, SimpleUser.class));
    }

    @Override
    public AuthenticationBuilder user(Map<String, String> user) {
        Objects.requireNonNull(user.get("id"));
        this.user(SimpleUser.builder().id(user.get("id")).username(user.get("username")).name(user.get("name")).userType(user.get("type")).build());
        return this;
    }

    @Override
    public AuthenticationBuilder role(List<Role> role) {
        this.authentication.getDimensions().addAll(role);
        return this;
    }

    @Override
    public AuthenticationBuilder role(String role) {
        return this.role(JSON.parseArray((String)role, SimpleRole.class));
    }

    @Override
    public AuthenticationBuilder permission(List<Permission> permission) {
        this.authentication.setPermissions(permission);
        return this;
    }

    public AuthenticationBuilder permission(JSONArray jsonArray) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONArray dataAccess;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            SimplePermission permission = new SimplePermission();
            permission.setId(jsonObject.getString("id"));
            permission.setName(jsonObject.getString("name"));
            permission.setOptions((Map<String, Object>)jsonObject.getJSONObject("options"));
            JSONArray actions = jsonObject.getJSONArray("actions");
            if (actions != null) {
                permission.setActions(new HashSet<String>(actions.toJavaList(String.class)));
            }
            if (null != (dataAccess = jsonObject.getJSONArray("dataAccesses"))) {
                permission.setDataAccesses(dataAccess.stream().map(JSONObject.class::cast).map(dataJson -> this.dataBuilderFactory.create().fromJson(dataJson.toJSONString()).build()).filter(Objects::nonNull).collect(Collectors.toSet()));
            }
            permissions.add(permission);
        }
        this.authentication.setPermissions(permissions);
        return this;
    }

    @Override
    public AuthenticationBuilder permission(String permissionJson) {
        return this.permission(JSON.parseArray((String)permissionJson));
    }

    @Override
    public AuthenticationBuilder attributes(String attributes) {
        this.authentication.getAttributes().putAll((Map)JSON.parseObject((String)attributes, Map.class, (Feature[])new Feature[0]));
        return this;
    }

    @Override
    public AuthenticationBuilder attributes(Map<String, Serializable> permission) {
        this.authentication.getAttributes().putAll(permission);
        return this;
    }

    public AuthenticationBuilder dimension(JSONArray json) {
        if (json == null) {
            return this;
        }
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            Object type = jsonObject.get((Object)"type");
            JSONObject options = jsonObject.getJSONObject("options");
            dimensions.add(SimpleDimension.of(jsonObject.getString("id"), jsonObject.getString("name"), type instanceof String ? SimpleDimensionType.of(String.valueOf(type)) : (DimensionType)jsonObject.getJSONObject("type").toJavaObject(SimpleDimensionType.class), (Map<String, Object>)options));
        }
        this.authentication.setDimensions((List<Dimension>)dimensions);
        return this;
    }

    @Override
    public AuthenticationBuilder json(String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        this.user((User)jsonObject.getObject("user", SimpleUser.class));
        if (jsonObject.containsKey((Object)"roles")) {
            this.role(jsonObject.getJSONArray("roles").toJavaList(SimpleRole.class));
        }
        if (jsonObject.containsKey((Object)"permissions")) {
            this.permission(jsonObject.getJSONArray("permissions"));
        }
        if (jsonObject.containsKey((Object)"dimensions")) {
            this.dimension(jsonObject.getJSONArray("dimensions"));
        }
        if (jsonObject.containsKey((Object)"attributes")) {
            this.attributes(Maps.transformValues((Map)jsonObject.getJSONObject("attributes"), Serializable.class::cast));
        }
        return this;
    }

    @Override
    public Authentication build() {
        return this.authentication;
    }
}

