/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple;

import java.util.List;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationHolder;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.ReactiveAuthenticationHolder;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.ReactiveAuthenticationManagerProvider;
import org.hswebframework.web.authorization.builder.AuthenticationBuilderFactory;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.dimension.DimensionManager;
import org.hswebframework.web.authorization.dimension.DimensionUserBindProvider;
import org.hswebframework.web.authorization.simple.CompositeReactiveAuthenticationManager;
import org.hswebframework.web.authorization.simple.DefaultDimensionManager;
import org.hswebframework.web.authorization.simple.builder.SimpleAuthenticationBuilderFactory;
import org.hswebframework.web.authorization.simple.builder.SimpleDataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.token.DefaultUserTokenManager;
import org.hswebframework.web.authorization.token.UserTokenAuthenticationSupplier;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.UserTokenReactiveAuthenticationSupplier;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidatorManager;
import org.hswebframework.web.authorization.twofactor.defaults.DefaultTwoFactorValidatorManager;
import org.hswebframework.web.convert.CustomMessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class DefaultAuthorizationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={UserTokenManager.class})
    @ConfigurationProperties(prefix="hsweb.user-token")
    public UserTokenManager userTokenManager() {
        return new DefaultUserTokenManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveAuthenticationManager reactiveAuthenticationManager(List<ReactiveAuthenticationManagerProvider> providers) {
        return new CompositeReactiveAuthenticationManager(providers);
    }

    @Bean
    @ConditionalOnBean(value={ReactiveAuthenticationManager.class})
    public UserTokenReactiveAuthenticationSupplier userTokenReactiveAuthenticationSupplier(UserTokenManager userTokenManager, ReactiveAuthenticationManager authenticationManager) {
        UserTokenReactiveAuthenticationSupplier supplier = new UserTokenReactiveAuthenticationSupplier(userTokenManager, authenticationManager);
        ReactiveAuthenticationHolder.addSupplier(supplier);
        return supplier;
    }

    @Bean
    @ConditionalOnBean(value={AuthenticationManager.class})
    public UserTokenAuthenticationSupplier userTokenAuthenticationSupplier(UserTokenManager userTokenManager, AuthenticationManager authenticationManager) {
        UserTokenAuthenticationSupplier supplier = new UserTokenAuthenticationSupplier(userTokenManager, authenticationManager);
        AuthenticationHolder.addSupplier(supplier);
        return supplier;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataAccessConfigBuilderFactory.class})
    @ConfigurationProperties(prefix="hsweb.authorization.data-access", ignoreInvalidFields=true)
    public SimpleDataAccessConfigBuilderFactory dataAccessConfigBuilderFactory() {
        return new SimpleDataAccessConfigBuilderFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={TwoFactorValidatorManager.class})
    @ConfigurationProperties(value="hsweb.authorize.two-factor")
    public DefaultTwoFactorValidatorManager defaultTwoFactorValidatorManager() {
        return new DefaultTwoFactorValidatorManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationBuilderFactory.class})
    public AuthenticationBuilderFactory authenticationBuilderFactory(DataAccessConfigBuilderFactory dataAccessConfigBuilderFactory) {
        return new SimpleAuthenticationBuilderFactory(dataAccessConfigBuilderFactory);
    }

    @Bean
    public CustomMessageConverter authenticationCustomMessageConverter(final AuthenticationBuilderFactory factory) {
        return new CustomMessageConverter(){

            public boolean support(Class clazz) {
                return clazz == Authentication.class;
            }

            public Object convert(Class clazz, byte[] message) {
                String json = new String(message);
                return factory.create().json(json).build();
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={DimensionManager.class})
    public DimensionManager defaultDimensionManager(ObjectProvider<DimensionUserBindProvider> bindProviders, ObjectProvider<DimensionProvider> providers) {
        DefaultDimensionManager manager = new DefaultDimensionManager();
        bindProviders.forEach(manager::addBindProvider);
        providers.forEach(manager::addProvider);
        return manager;
    }
}

