/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.exception;

import java.util.Set;
import org.hswebframework.web.exception.I18nSupportException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.FORBIDDEN)
public class AccessDenyException
extends I18nSupportException {
    private static final long serialVersionUID = -5135300127303801430L;
    private String code;

    public AccessDenyException() {
        this("error.access_denied");
    }

    public AccessDenyException(String message) {
        super(message, new Object[0]);
    }

    public AccessDenyException(String permission, Set<String> actions) {
        super("error.permission_denied", new Object[]{permission, actions});
    }

    public AccessDenyException(String message, String code) {
        this(message, code, null);
    }

    public AccessDenyException(String message, Throwable cause) {
        this(message, "access_denied", cause);
    }

    public AccessDenyException(String message, String code, Throwable cause) {
        super(message, cause, new Object[]{code});
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static class NoStackTrace
    extends AccessDenyException {
        public NoStackTrace() {
        }

        public NoStackTrace(String message) {
            super(message);
        }

        public NoStackTrace(String permission, Set<String> actions) {
            super(permission, actions);
        }

        public NoStackTrace(String message, String code) {
            super(message, code);
        }

        public NoStackTrace(String message, Throwable cause) {
            super(message, cause);
        }

        public NoStackTrace(String message, String code, Throwable cause) {
            super(message, code, cause);
        }

        public final synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

