/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.db;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableWrongDbException;
import org.flowable.common.engine.impl.db.ServiceSqlScriptBasedDbSchemaManager;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class IdmDbSchemaManager
extends ServiceSqlScriptBasedDbSchemaManager {
    private static final String IDM_PROPERTY_TABLE = "ACT_ID_PROPERTY";
    private static final String VERSION_PROPERTY = "schema.version";
    private static final String SCHEMA_COMPONENT = "identity";

    public IdmDbSchemaManager() {
        super(IDM_PROPERTY_TABLE, SCHEMA_COMPONENT, null, VERSION_PROPERTY);
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/idm/db/";
    }

    protected String getPropertyTable() {
        return IDM_PROPERTY_TABLE;
    }

    protected String getUpgradeStartVersion() {
        return "5.99.0.0";
    }

    protected void internalDbSchemaCreate() {
        if (this.isIdmGroupTablePresent()) {
            this.schemaUpdate();
        } else {
            super.internalDbSchemaCreate();
        }
    }

    protected boolean isUpdateNeeded() {
        boolean propertyTablePresent = this.isTablePresent(IDM_PROPERTY_TABLE);
        if (!propertyTablePresent) {
            return this.isIdmGroupTablePresent();
        }
        return true;
    }

    public boolean isIdmGroupTablePresent() {
        return this.isTablePresent("ACT_ID_GROUP");
    }

    public void schemaCheckVersion() {
        try {
            String dbVersion = this.getSchemaVersion();
            if (!"7.0.1.1".equals(dbVersion)) {
                throw new FlowableWrongDbException("7.0.1.1", dbVersion);
            }
            String errorMessage = null;
            if (!this.isTablePresent(IDM_PROPERTY_TABLE)) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable IDM database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("no flowable tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in flowable.cfg.xml for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get db schema version", (Throwable)e);
        }
        this.logger.debug("flowable idm db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.contains("Table") && exceptionMessage.contains("not found")) {
                return true;
            }
            if ((exceptionMessage.contains("Table") || exceptionMessage.contains("table")) && exceptionMessage.contains("doesn't exist")) {
                return true;
            }
            if ((exceptionMessage.contains("relation") || exceptionMessage.contains("table")) && exceptionMessage.contains("does not exist")) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsIdmEngineBuild() {
        String databaseSchemaUpdate = CommandContextUtil.getIdmEngineConfiguration().getDatabaseSchemaUpdate();
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.schemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.schemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.schemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.schemaUpdate();
        }
    }
}

