/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.fop.events.DefaultEventBroadcaster;
import org.apache.fop.events.EventBroadcaster;
import org.docx4j.fonts.FontUtils;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.apps.io.ResourceResolverFactory;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontEventAdapter;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.autodetect.FontFileFinder;
import org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.fonts.microsoft.MicrosoftFontsRegistry;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalFonts {
    protected static Logger log = LoggerFactory.getLogger(PhysicalFonts.class);
    protected static FontCache fontCache;
    private static final Map<String, PhysicalFont> physicalFontMap;
    private static final Map<String, PhysicalFont> physicalFontMapByFilenameLowercase;
    private static InternalResourceResolver fontResolver;
    private static FontInfoFinder fontInfoFinder;
    private static String osName;
    private static String regex;
    private static boolean loggedWarningAlready;

    @Deprecated
    public static Map<String, PhysicalFont> getPhysicalFonts() {
        return physicalFontMap;
    }

    public static PhysicalFont get(String key) {
        return physicalFontMap.get(key.toLowerCase());
    }

    public static void put(String key, PhysicalFont pf) {
        if (physicalFontMap.get(key.toLowerCase()) != null) {
            log.warn("Overwriting existing physicalFontMap entry: " + key.toLowerCase());
        }
        physicalFontMap.put(key.toLowerCase(), pf);
    }

    public static String getRegex() {
        return regex;
    }

    public static void setRegex(String regex) {
        PhysicalFonts.regex = regex;
    }

    public static final void discoverPhysicalFonts() throws Exception {
        FontEventAdapter fea = new FontEventAdapter((EventBroadcaster)new DefaultEventBroadcaster());
        FontFileFinder fontFileFinder = new FontFileFinder(fea);
        List<URL> fontFileList = fontFileFinder.find();
        if (regex == null) {
            Iterator<URL> iter = fontFileList.iterator();
            while (iter.hasNext()) {
                URI fontUrl = PhysicalFonts.getURI(iter.next());
                PhysicalFonts.addPhysicalFont(fontUrl);
            }
        } else {
            Pattern pattern = Pattern.compile(regex);
            Iterator<URL> iter = fontFileList.iterator();
            while (iter.hasNext()) {
                URI fontUrl = PhysicalFonts.getURI(iter.next());
                if (!pattern.matcher(fontUrl.toString()).matches()) continue;
                PhysicalFonts.addPhysicalFont(fontUrl);
            }
        }
        fontCache.save();
    }

    private static URI getURI(Object o) throws Exception {
        if (o instanceof File) {
            File f = (File)o;
            return f.toURL().toURI();
        }
        if (o instanceof URL) {
            return ((URL)o).toURI();
        }
        throw new Exception("Unexpected object:" + o.getClass().getName());
    }

    public static void addPhysicalFont(URI fontUrl) {
        PhysicalFonts.addPhysicalFonts(null, fontUrl);
    }

    public static void addPhysicalFonts(String nameAsInFontTablePart, URI fontUrl) {
        List<PhysicalFont> physicalFonts = PhysicalFonts.getPhysicalFont(nameAsInFontTablePart, fontUrl);
        if (physicalFonts == null) {
            return;
        }
        for (PhysicalFont pf : physicalFonts) {
            if (pf == null) continue;
            PhysicalFonts.put(pf.getName(), pf);
            log.debug("Added '" + pf.getName() + "' -> " + pf.getEmbeddedURI());
            if (nameAsInFontTablePart != null && PhysicalFonts.get(nameAsInFontTablePart) == null) {
                PhysicalFonts.put(nameAsInFontTablePart, pf);
                log.debug("Added '" + nameAsInFontTablePart + "' -> " + pf.getEmbeddedURI());
            }
            String filename = pf.getEmbeddedURI().toString();
            filename = filename.substring(filename.lastIndexOf("/") + 1).toLowerCase();
            if (osName.startsWith("Mac")) {
                filename = filename.replace("%20", " ");
            }
            physicalFontMapByFilenameLowercase.put(filename, pf);
            log.debug("added to filename map: " + filename);
        }
    }

    public static List<PhysicalFont> getPhysicalFont(String nameAsInFontTablePart, URI fontUrl) {
        ArrayList<PhysicalFont> pfList = new ArrayList<PhysicalFont>();
        log.debug(nameAsInFontTablePart);
        EmbedFontInfo[] embedFontInfoList = fontInfoFinder.find(fontUrl, fontResolver, fontCache);
        if (embedFontInfoList == null) {
            if (PhysicalFonts.fontInfoFinder.log.isDebugEnabled()) {
                log.warn("Aborting: " + fontUrl.toString());
            } else {
                log.warn("Aborting: " + fontUrl.toString() + " (to investigate, set org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder to DEBUG)");
            }
            return null;
        }
        StringBuffer debug = new StringBuffer();
        for (EmbedFontInfo fontInfo : embedFontInfoList) {
            block15: {
                if (fontInfo == null) continue;
                debug.append("------- \n");
                try {
                    debug.append(fontInfo.getPostScriptName() + "\n");
                    if (!fontInfo.isEmbeddable()) {
                        log.warn(fontInfo.getEmbedURI() + " is not embeddable; ignoring this font.");
                        continue;
                    }
                }
                catch (Exception e1) {
                    if (loggedWarningAlready) break block15;
                    log.warn("Not using patched FOP; isEmbeddable() method missing.");
                    loggedWarningAlready = true;
                }
            }
            FontTriplet triplet = fontInfo.getFontTriplets().get(0);
            String lower = fontInfo.getEmbedURI().toString().toLowerCase();
            log.debug("Processing physical font: " + lower);
            debug.append(".. triplet " + triplet.getName() + " (priority " + triplet.getPriority() + "\n");
            PhysicalFont pf = null;
            if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.endsWith(".ttc")) {
                pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
            } else if (lower.endsWith(".pfb")) {
                String afm = FontUtils.pathFromURL(lower);
                afm = afm.substring(0, afm.length() - 4) + ".afm";
                log.debug("Looking for: " + afm);
                File f = new File(afm);
                if (f.exists()) {
                    log.debug(".. found");
                    pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                } else {
                    String pfm = FontUtils.pathFromURL(lower);
                    pfm = pfm.substring(0, pfm.length() - 4) + ".pfm";
                    log.debug("Looking for: " + pfm);
                    f = new File(pfm);
                    if (f.exists()) {
                        log.debug(".. found");
                        pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                    } else {
                        log.warn("Skipping " + triplet.getName() + "; couldn't find .afm or .pfm for : " + fontInfo.getEmbedURI());
                    }
                }
            } else {
                log.warn("Skipping " + triplet.getName() + "; unsupported type: " + fontInfo.getEmbedURI());
            }
            if (pf == null) continue;
            pfList.add(pf);
        }
        log.debug(debug.toString());
        return pfList;
    }

    public static PhysicalFont getBoldForm(PhysicalFont pf) {
        String filename;
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getBold() == null) {
            log.debug("No bold form for: " + pf.getName());
            return null;
        }
        if (osName.startsWith("Mac")) {
            if (msFont.getBold().getMac() == null) {
                log.debug("No bold form for mac for: " + pf.getName());
                return null;
            }
            filename = msFont.getBold().getMac().toLowerCase();
        } else {
            filename = msFont.getBold().getFilename().toLowerCase();
        }
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getBoldItalicForm(PhysicalFont pf) {
        String filename;
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getBolditalic() == null) {
            log.debug("No Bolditalic form for: " + pf.getName());
            return null;
        }
        if (osName.startsWith("Mac")) {
            if (msFont.getBolditalic().getMac() == null) {
                log.debug("No Bolditalic form for mac for: " + pf.getName());
                return null;
            }
            filename = msFont.getBolditalic().getMac().toLowerCase();
        } else {
            filename = msFont.getBolditalic().getFilename().toLowerCase();
        }
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getItalicForm(PhysicalFont pf) {
        String filename;
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.debug("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getItalic() == null) {
            log.info("No italic form for: " + pf.getName());
            return null;
        }
        if (osName.startsWith("Mac")) {
            if (msFont.getItalic().getMac() == null) {
                log.info("No italic form for mac for: " + pf.getName());
                return null;
            }
            filename = msFont.getItalic().getMac().toLowerCase();
        } else {
            filename = msFont.getItalic().getFilename().toLowerCase();
        }
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static String getPhysicalFont(OpcPackage wmlPackage, String fontName) {
        log.debug("looking for: " + fontName);
        if (!(wmlPackage instanceof WordprocessingMLPackage)) {
            log.error("Implement me for pptx4j");
            return null;
        }
        PhysicalFont pf = ((WordprocessingMLPackage)wmlPackage).getFontMapper().get(fontName);
        if (pf != null) {
            log.debug("Font '" + fontName + "' maps to " + pf.getName());
            return pf.getName();
        }
        log.warn("Font '" + fontName + "' is not mapped to a physical font. ");
        return null;
    }

    public static void main(String[] args) throws Exception {
        PhysicalFonts.discoverPhysicalFonts();
        System.out.println("That should have listed your physical fonts (provided you have logging enabled).");
    }

    static {
        try {
            osName = System.getProperty("os.name");
            fontCache = FontCache.load();
            if (fontCache == null) {
                fontCache = new FontCache();
            }
            physicalFontMap = new HashMap<String, PhysicalFont>();
            physicalFontMapByFilenameLowercase = new HashMap<String, PhysicalFont>();
            URI baseUri = new URI("/");
            fontResolver = new InternalResourceResolver(baseUri, ResourceResolverFactory.createDefaultResourceResolver());
            fontInfoFinder = new FontInfoFinder();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        loggedWarningAlready = false;
    }
}

