/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.model.datastorage.migration.AbstractMigrator;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.RPr;
import org.opendope.answers.Answer;
import org.opendope.answers.Answers;
import org.opendope.questions.Question;
import org.opendope.questions.Questionnaire;
import org.opendope.questions.Response;
import org.opendope.xpaths.ObjectFactory;
import org.opendope.xpaths.Xpaths;

public class AbstractMigratorUsingAnswersFormat
extends AbstractMigrator {
    protected QuestionsPart questionsPart;
    protected StandardisedAnswersPart standardisedAnswersPart;
    protected Map<String, String> keys = new HashMap<String, String>();

    @Override
    protected void createParts(WordprocessingMLPackage pkgOut) throws InvalidFormatException {
        super.createParts(pkgOut);
        this.questionsPart = new QuestionsPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.questionsPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.addPropertiesPart(pkgOut, this.questionsPart, "http://opendope.org/questions");
        this.questionsPart.setJaxbElement(new Questionnaire());
        Questionnaire.Questions questions = new Questionnaire.Questions();
        ((Questionnaire)this.questionsPart.getJaxbElement()).setQuestions(questions);
        this.standardisedAnswersPart = new StandardisedAnswersPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.standardisedAnswersPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.storeItemID = this.addPropertiesPart(pkgOut, this.standardisedAnswersPart, "http://opendope.org/answers");
        this.standardisedAnswersPart.setJaxbElement(new Answers());
    }

    protected void createContentControl(RPr rPr, List<Object> replacementContent, String key) {
        if (!this.keys.containsKey(key)) {
            this.addPartEntries(key);
            this.keys.put(key, key);
        }
        super.createContentControl(rPr, replacementContent, key, "/oda:answers/oda:answer[@id='" + key + "']", "xmlns:oda='http://opendope.org/answers'");
    }

    private void addPartEntries(String key) {
        Answer a = new Answer();
        a.setId(key);
        a.setValue("${" + key + "}");
        ((Answers)this.standardisedAnswersPart.getJaxbElement()).getAnswerOrRepeat().add(a);
        Xpaths.Xpath xp = new ObjectFactory().createXpathsXpath();
        xp.setId(key);
        xp.setQuestionID(key);
        xp.setPrepopulate(false);
        xp.setRequired(false);
        xp.setType("string");
        Xpaths.Xpath.DataBinding db = new ObjectFactory().createXpathsXpathDataBinding();
        db.setXpath("/oda:answers/oda:answer[@id='" + key + "']");
        db.setPrefixMappings("xmlns:oda='http://opendope.org/answers'");
        db.setStoreItemID(this.storeItemID);
        xp.setDataBinding(db);
        ((Xpaths)this.xPathsPart.getJaxbElement()).getXpath().add(xp);
        Question q = new Question();
        q.setId(key);
        q.setText(key + "?");
        Response r = new Response();
        r.setFree(new Response.Free());
        q.setResponse(r);
        ((Questionnaire)this.questionsPart.getJaxbElement()).getQuestions().getQuestion().add(q);
    }
}

