/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.table.tc;

import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.table.tc.AbstractTcProperty;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.TcPr;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class TextAlignmentVertical
extends AbstractTcProperty {
    public static final String CSS_NAME = "vertical-align";
    public static final String FO_NAME = "display-align";

    @Override
    public String getCssName() {
        return CSS_NAME;
    }

    public TextAlignmentVertical() {
        CTVerticalJc textAlignment = Context.getWmlObjectFactory().createCTVerticalJc();
        textAlignment.setVal(STVerticalJc.TOP);
        this.setObject(textAlignment);
    }

    public TextAlignmentVertical(CTVerticalJc textAlignment) {
        this.setObject(textAlignment);
    }

    public TextAlignmentVertical(CSSValue value) {
        this.debug(CSS_NAME, value);
        CTVerticalJc textAlignment = Context.getWmlObjectFactory().createCTVerticalJc();
        if (value.getCssText().toLowerCase().equals("top")) {
            textAlignment.setVal(STVerticalJc.TOP);
        } else if (value.getCssText().toLowerCase().equals("middle")) {
            textAlignment.setVal(STVerticalJc.CENTER);
        } else if (value.getCssText().toLowerCase().equals("bottom")) {
            textAlignment.setVal(STVerticalJc.BOTTOM);
        } else {
            log.warn("How to handle vertical-align: " + value.getCssText());
            textAlignment.setVal(STVerticalJc.CENTER);
        }
        this.setObject(textAlignment);
    }

    @Override
    public String getCssProperty() {
        STVerticalJc val = ((CTVerticalJc)this.getObject()).getVal();
        if (val == STVerticalJc.TOP || val == STVerticalJc.BOTTOM) {
            return TextAlignmentVertical.composeCss(CSS_NAME, val.value());
        }
        if (val == STVerticalJc.CENTER) {
            return TextAlignmentVertical.composeCss(CSS_NAME, "middle");
        }
        return "";
    }

    @Override
    public void setXslFO(Element foElement) {
        STVerticalJc val = ((CTVerticalJc)this.getObject()).getVal();
        if (val == STVerticalJc.TOP) {
            foElement.setAttribute(FO_NAME, "before");
        } else if (val == STVerticalJc.CENTER) {
            foElement.setAttribute(FO_NAME, "center");
        } else if (val == STVerticalJc.BOTTOM) {
            foElement.setAttribute(FO_NAME, "after");
        } else {
            log.warn("How to handle vertical alignment of " + val.value());
        }
    }

    @Override
    public void set(TcPr tcPr) {
        tcPr.setVAlign((CTVerticalJc)this.getObject());
    }
}

