/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.space;

import java.util.Arrays;
import org.deeplearning4j.rl4j.space.Box;
import org.deeplearning4j.rl4j.space.ObservationSpace;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public final class GymObservationSpace<O>
implements ObservationSpace<O> {
    private final String name;
    private final int[] shape;
    private final INDArray low;
    private final INDArray high;

    public GymObservationSpace(JSONObject jsonObject) {
        int i;
        this.name = jsonObject.getString("name");
        JSONArray arr = jsonObject.getJSONArray("shape");
        int lg = arr.length();
        this.shape = new int[lg];
        for (int i2 = 0; i2 < lg; ++i2) {
            this.shape[i2] = arr.getInt(i2);
        }
        this.low = Nd4j.create((int[])this.shape);
        this.high = Nd4j.create((int[])this.shape);
        JSONArray lowJson = jsonObject.getJSONArray("low");
        JSONArray highJson = jsonObject.getJSONArray("high");
        int size = this.shape[0];
        for (i = 1; i < this.shape.length; ++i) {
            size *= this.shape[i];
        }
        for (i = 0; i < size; ++i) {
            this.low.putScalar(i, lowJson.getDouble(i));
            this.high.putScalar(i, highJson.getDouble(i));
        }
    }

    public O getValue(JSONObject o, String key) {
        switch (this.name) {
            case "Box": {
                JSONArray arr = o.getJSONArray(key);
                return (O)new Box(arr);
            }
        }
        throw new RuntimeException("Invalid environment name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public INDArray getLow() {
        return this.low;
    }

    @Override
    public INDArray getHigh() {
        return this.high;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GymObservationSpace)) {
            return false;
        }
        GymObservationSpace other = (GymObservationSpace)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        INDArray this$low = this.getLow();
        INDArray other$low = other.getLow();
        if (this$low == null ? other$low != null : !this$low.equals(other$low)) {
            return false;
        }
        INDArray this$high = this.getHigh();
        INDArray other$high = other.getHigh();
        return !(this$high == null ? other$high != null : !this$high.equals(other$high));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getShape());
        INDArray $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : $low.hashCode());
        INDArray $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : $high.hashCode());
        return result;
    }

    public String toString() {
        return "GymObservationSpace(name=" + this.getName() + ", shape=" + Arrays.toString(this.getShape()) + ", low=" + this.getLow() + ", high=" + this.getHigh() + ")";
    }
}

