/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.gym;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientUtils {
    public static JsonNode post(String url, JSONObject json) {
        HttpResponse jsonResponse = null;
        try {
            jsonResponse = Unirest.post((String)url).header("content-type", "application/json").body(json).asJson();
        }
        catch (UnirestException e) {
            ClientUtils.unirestCrash(e);
        }
        return (JsonNode)jsonResponse.getBody();
    }

    public static JSONObject get(String url) {
        HttpResponse jsonResponse = null;
        try {
            jsonResponse = Unirest.get((String)url).header("content-type", "application/json").asJson();
        }
        catch (UnirestException e) {
            ClientUtils.unirestCrash(e);
        }
        ClientUtils.checkReply((HttpResponse<JsonNode>)jsonResponse, url);
        return ((JsonNode)jsonResponse.getBody()).getObject();
    }

    public static void checkReply(HttpResponse<JsonNode> res, String url) {
        if (res.getBody() == null) {
            throw new RuntimeException("Invalid reply at: " + url);
        }
    }

    public static void unirestCrash(UnirestException e) {
        if (e.getCause().getCause().getCause() instanceof JSONException) {
            throw new RuntimeException("Couldn't parse json reply.");
        }
        throw new RuntimeException("Connection error");
    }
}

