/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.gym;

import org.deeplearning4j.gym.Client;
import org.deeplearning4j.gym.ClientUtils;
import org.deeplearning4j.rl4j.space.ActionSpace;
import org.deeplearning4j.rl4j.space.DiscreteSpace;
import org.deeplearning4j.rl4j.space.GymObservationSpace;
import org.deeplearning4j.rl4j.space.HighLowDiscrete;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ClientFactory {
    public static <O, A, AS extends ActionSpace<A>> Client<O, A, AS> build(String url, String envId, boolean render) {
        String instanceId;
        JSONObject body = new JSONObject().put("env_id", (Object)envId);
        JSONObject reply = ClientUtils.post(url + "/v1/envs/", body).getObject();
        try {
            instanceId = reply.getString("instance_id");
        }
        catch (JSONException e) {
            throw new RuntimeException("Environment id not found");
        }
        GymObservationSpace<O> observationSpace = ClientFactory.fetchObservationSpace(url, instanceId);
        AS actionSpace = ClientFactory.fetchActionSpace(url, instanceId);
        return new Client(url, envId, instanceId, observationSpace, actionSpace, render);
    }

    public static <O, A, AS extends ActionSpace<A>> Client<O, A, AS> build(String envId, boolean render) {
        return ClientFactory.build("http://127.0.0.1:5000", envId, render);
    }

    public static <AS extends ActionSpace> AS fetchActionSpace(String url, String instanceId) {
        String infoName;
        JSONObject reply = ClientUtils.get(url + "/v1/envs/" + instanceId + "/action_space/");
        JSONObject info = reply.getJSONObject("info");
        switch (infoName = info.getString("name")) {
            case "Discrete": {
                return (AS)new DiscreteSpace(info.getInt("n"));
            }
            case "HighLow": {
                int numRows = info.getInt("num_rows");
                int size = 3 * numRows;
                JSONArray matrixJson = info.getJSONArray("matrix");
                INDArray matrix = Nd4j.create((int)numRows, (int)3);
                for (int i = 0; i < size; ++i) {
                    matrix.putScalar(i, matrixJson.getDouble(i));
                }
                matrix.reshape(numRows, 3);
                return (AS)new HighLowDiscrete(matrix);
            }
        }
        throw new RuntimeException("Unknown action space " + infoName);
    }

    public static <O> GymObservationSpace<O> fetchObservationSpace(String url, String instanceId) {
        JSONObject reply = ClientUtils.get(url + "/v1/envs/" + instanceId + "/observation_space/");
        JSONObject info = reply.getJSONObject("info");
        return new GymObservationSpace(info);
    }
}

