/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.CollectionTable;

public class ListGetMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"get", (Object)"CollectionExpression", (Object)1));
        }
        CollectionExpression listExpr = (CollectionExpression)expr;
        AbstractMemberMetaData mmd = listExpr.getJavaTypeMapping().getMemberMetaData();
        if (!List.class.isAssignableFrom(mmd.getType())) {
            throw new UnsupportedOperationException("Query contains " + expr + ".get(int) yet the field is not a List!");
        }
        if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
            throw new UnsupportedOperationException("Query contains " + expr + ".get(int) yet the field is not an 'indexed' List!");
        }
        SQLExpression idxExpr = (SQLExpression)args.get(0);
        if (idxExpr instanceof SQLLiteral) {
            if (!(((SQLLiteral)((Object)idxExpr)).getValue() instanceof Number)) {
                throw new UnsupportedOperationException("Query contains " + expr + ".get(int) yet the index is not a numeric literal so not yet supported");
            }
        } else {
            throw new UnsupportedOperationException("Query contains " + expr + ".get(int) yet the index is not a numeric literal so not yet supported");
        }
        if (listExpr instanceof CollectionLiteral && idxExpr instanceof SQLLiteral) {
            CollectionLiteral lit = (CollectionLiteral)expr;
            if (lit.getValue() == null) {
                return new NullLiteral(this.stmt, null, null, null);
            }
            return lit.invoke("get", args);
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            return this.getAsInnerJoin(listExpr, idxExpr);
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.ORDERING || this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.RESULT) {
            return this.getAsSubquery(listExpr, idxExpr);
        }
        throw new NucleusException("List.get() is not supported for " + listExpr + " with argument " + idxExpr + " for query component " + this.stmt.getQueryGenerator().getCompilationComponent());
    }

    protected SQLExpression getAsSubquery(CollectionExpression listExpr, SQLExpression idxExpr) {
        AbstractMemberMetaData mmd = listExpr.getJavaTypeMapping().getMemberMetaData();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        JavaTypeMapping ownerMapping = null;
        JavaTypeMapping indexMapping = null;
        JavaTypeMapping elemMapping = null;
        DatastoreContainerObject listTbl = null;
        if (mmd != null) {
            AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
            if (mmd.getJoinMetaData() != null || relatedMmds != null && relatedMmds[0].getJoinMetaData() != null) {
                listTbl = storeMgr.getDatastoreContainerObject(mmd);
                ownerMapping = ((CollectionTable)listTbl).getOwnerMapping();
                indexMapping = ((CollectionTable)listTbl).getOrderMapping();
                elemMapping = ((CollectionTable)listTbl).getElementMapping();
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                listTbl = elemTbl;
                if (relatedMmds != null) {
                    ownerMapping = elemTbl.getMemberMapping(relatedMmds[0]);
                    indexMapping = elemTbl.getExternalMapping(mmd, 4);
                    elemMapping = elemTbl.getIdMapping();
                } else {
                    ownerMapping = elemTbl.getExternalMapping(mmd, 5);
                    indexMapping = elemTbl.getExternalMapping(mmd, 4);
                    elemMapping = elemTbl.getIdMapping();
                }
            }
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, listTbl, null, null);
        subStmt.setClassLoaderResolver(this.clr);
        SQLExpression valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemMapping);
        subStmt.select(valExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, listExpr.getSQLTable(), listExpr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        SQLExpression keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), indexMapping);
        subStmt.whereAnd(keyExpr.eq(idxExpr), true);
        return new SubqueryExpression(this.stmt, subStmt);
    }

    protected SQLExpression getAsInnerJoin(CollectionExpression listExpr, SQLExpression idxExpr) {
        JavaTypeMapping m = listExpr.getJavaTypeMapping();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = m.getMemberMetaData();
        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
        if (mmd.getJoinMetaData() != null || relatedMmds != null && relatedMmds[0].getJoinMetaData() != null) {
            CollectionTable joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(mmd);
            SQLTable joinSqlTbl = this.stmt.innerJoin(listExpr.getSQLTable(), listExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
            SQLExpression idxSqlExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOrderMapping());
            this.stmt.whereAnd(idxSqlExpr.eq(idxExpr), true);
            SQLExpression valueExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
            return valueExpr;
        }
        DatastoreClass elementTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
        JavaTypeMapping targetMapping = null;
        JavaTypeMapping orderMapping = null;
        if (relatedMmds != null) {
            targetMapping = elementTbl.getMemberMapping(relatedMmds[0]);
            orderMapping = elementTbl.getExternalMapping(mmd, 4);
        } else {
            targetMapping = elementTbl.getExternalMapping(mmd, 5);
            orderMapping = elementTbl.getExternalMapping(mmd, 4);
        }
        SQLTable elemSqlTbl = this.stmt.innerJoin(listExpr.getSQLTable(), listExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)elementTbl, null, targetMapping, null, null);
        SQLExpression idxSqlExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, orderMapping);
        this.stmt.whereAnd(idxSqlExpr.eq(idxExpr), true);
        return this.exprFactory.newExpression(this.stmt, elemSqlTbl, elementTbl.getIdMapping());
    }
}

