/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.ruledcategorizers;

import java.io.IOException;
import java.util.Locale;
import org.daisy.pipeline.nlp.TextCategorizer;
import org.daisy.pipeline.nlp.impl.ResourceUtils;
import org.daisy.pipeline.nlp.impl.matchrules.AbbrMatchRule;
import org.daisy.pipeline.nlp.impl.matchrules.CompactAbbrMatchRule;
import org.daisy.pipeline.nlp.impl.matchrules.RegexMatchRule;
import org.daisy.pipeline.nlp.ruledcategorizers.RuledMultilangCategorizer;

public class RuledFrenchCategorizer
extends RuledMultilangCategorizer {
    @Override
    public void init(TextCategorizer.MatchMode matchMode) throws IOException {
        super.init(matchMode);
        RegexMatchRule rsm = new RegexMatchRule(TextCategorizer.Category.COMMON, RuledMultilangCategorizer.COMMON_WORD_MAX_PRIORITY + 1, true, this.mMatchMode);
        rsm.init(CommonWordPattern + "[\u2019']?");
        this.addRule(rsm);
        rsm = new RegexMatchRule(TextCategorizer.Category.TIME, NUMBER_COMPOSED_MAX_PRIORITY, true, this.mMatchMode);
        rsm.init("(2[0-4]|[01][0-9])[ ]?h[ ]?[0-6][0-9](?![0-9])");
        this.addRule(rsm);
        String dictFolder = "dictionaries";
        AbbrMatchRule amr = new AbbrMatchRule(TextCategorizer.Category.ABBREVIATION, DICTIONARY_MAX_PRIORITY, true, this.mMatchMode, false, Locale.FRANCE);
        amr.init(ResourceUtils.readLines("dictionaries", "dot_abbr_fr.txt"));
        this.addRule(amr);
        CompactAbbrMatchRule cmr = new CompactAbbrMatchRule(TextCategorizer.Category.ABBREVIATION, DICTIONARY_MAX_PRIORITY, true, this.mMatchMode, false, Locale.FRANCE);
        cmr.init(ResourceUtils.readLines("dictionaries", "compact_abbr_fr.txt"));
        this.addRule(cmr);
    }
}

