/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.impl.matchrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.daisy.pipeline.nlp.TextCategorizer;
import org.daisy.pipeline.nlp.impl.FullMatchStringFinder;
import org.daisy.pipeline.nlp.impl.IStringFinder;
import org.daisy.pipeline.nlp.impl.MatchRule;
import org.daisy.pipeline.nlp.impl.PrefixMatchStringFinder;

public class WordListMatchRule
extends MatchRule {
    private boolean mCapitalSensitive;
    private IStringFinder mStringFinder;
    private Locale mLocale;

    public WordListMatchRule(TextCategorizer.Category category, int priority, boolean caseSensitive, TextCategorizer.MatchMode matchMode, boolean capitalSensitive, Locale locale) {
        super(category, priority, caseSensitive, matchMode);
        this.mLocale = locale;
        this.mCapitalSensitive = capitalSensitive;
        switch (matchMode) {
            case FULL_MATCH: {
                this.mStringFinder = new FullMatchStringFinder();
            }
        }
        this.mStringFinder = new PrefixMatchStringFinder();
    }

    public void init(Collection<String> prefixes) {
        Collection<String> tocompile;
        if (this.mCaseSensitive) {
            if (!this.mCapitalSensitive) {
                tocompile = new ArrayList<String>();
                tocompile.addAll(prefixes);
                for (String prefix : prefixes) {
                    String lw = prefix.toLowerCase(this.mLocale);
                    tocompile.add(lw.substring(0, 1) + prefix.substring(1));
                }
            } else {
                tocompile = prefixes;
            }
        } else {
            String[] lowerCasePrefixes = new String[prefixes.size()];
            int k = 0;
            for (String prefix : prefixes) {
                lowerCasePrefixes[k++] = prefix.toLowerCase(this.mLocale);
            }
            tocompile = Arrays.asList(lowerCasePrefixes);
        }
        this.mStringFinder.compile(tocompile);
    }

    @Override
    protected String match(String input) {
        return this.mStringFinder.find(input);
    }

    @Override
    public boolean threadsafe() {
        return this.mStringFinder.threadsafe();
    }
}

