/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.impl.matchrules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.daisy.pipeline.nlp.TextCategorizer;
import org.daisy.pipeline.nlp.impl.MatchRule;

public class RegexMatchRule
extends MatchRule {
    private Pattern mPattern;

    public RegexMatchRule(TextCategorizer.Category category, int priority, boolean caseSensitive, TextCategorizer.MatchMode matchMode) {
        super(category, priority, caseSensitive, matchMode);
    }

    public void init(String regexp) {
        switch (this.mMatchMode) {
            case FULL_MATCH: {
                regexp = regexp + "$";
                break;
            }
        }
        int flags = 104;
        if (!this.mCaseSensitive) {
            flags |= 2;
        }
        this.mPattern = Pattern.compile(regexp, flags);
    }

    @Override
    protected String match(String input) {
        Matcher m = this.mPattern.matcher(input);
        if (m.lookingAt()) {
            return m.group(0);
        }
        return null;
    }

    @Override
    public boolean threadsafe() {
        return true;
    }
}

