/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.impl.matchrules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.daisy.pipeline.nlp.TextCategorizer;
import org.daisy.pipeline.nlp.impl.MatchRule;

public class RegexAheadMatchRule
extends MatchRule {
    private Pattern mPattern;
    private Pattern mPatternForward;

    public RegexAheadMatchRule(TextCategorizer.Category category, int priority, boolean caseSensitive, TextCategorizer.MatchMode matchMode) {
        super(category, priority, caseSensitive, matchMode);
    }

    public void init(String regexp, String regexpForward) {
        int flags = 72;
        if (!this.mCaseSensitive) {
            flags |= 2;
        }
        this.mPattern = Pattern.compile(regexp, flags);
        this.mPatternForward = Pattern.compile(regexpForward, flags);
    }

    @Override
    protected String match(String input) {
        Matcher m = this.mPattern.matcher(input);
        switch (this.mMatchMode) {
            case FULL_MATCH: {
                if (!m.matches()) break;
                return m.group(0);
            }
            case PREFIX_MATCH: {
                if (!m.lookingAt()) break;
                Matcher m2 = this.mPatternForward.matcher(input);
                if (m2.lookingAt()) {
                    return m2.group(0);
                }
                System.err.println("** critical error **: " + this.mPatternForward.pattern() + " not included in " + this.mPattern.pattern());
            }
        }
        return null;
    }

    @Override
    public boolean threadsafe() {
        return true;
    }
}

