/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.impl.matchrules;

import org.daisy.pipeline.nlp.TextCategorizer;
import org.daisy.pipeline.nlp.impl.MatchRule;

public class NumberRangeMatchRule
extends MatchRule {
    public NumberRangeMatchRule(TextCategorizer.Category category, int priority, TextCategorizer.MatchMode matchMode) {
        super(category, priority, false, matchMode);
    }

    @Override
    protected String match(String input) {
        int k;
        if (input.charAt(0) <= '0' || input.charAt(0) > '9') {
            return null;
        }
        for (k = 1; k < input.length() && input.charAt(k) >= '0' && input.charAt(k) <= '9'; ++k) {
        }
        if (k == input.length() || input.charAt(k) != '-') {
            return null;
        }
        int prevk = k++;
        if (k >= input.length() || input.charAt(k) <= '0' || input.charAt(k) > '9') {
            return null;
        }
        ++k;
        while (k < input.length() && input.charAt(k) >= '0' && input.charAt(k) <= '9') {
            ++k;
        }
        if (k == prevk + 2 || Integer.valueOf(input.substring(0, prevk)) > Integer.valueOf(input.substring(prevk + 1, k)) || this.mMatchMode == TextCategorizer.MatchMode.FULL_MATCH && k != input.length()) {
            return null;
        }
        return input.substring(0, k);
    }

    @Override
    public boolean threadsafe() {
        return true;
    }
}

