/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.impl;

import java.util.Collection;
import java.util.TreeMap;
import org.daisy.pipeline.nlp.impl.IStringFinder;

public class PrefixMatchStringFinder
implements IStringFinder {
    private Trie mTrieRoot;

    @Override
    public void compile(Collection<String> matchable) {
        this.mTrieRoot = new Trie();
        for (String s : matchable) {
            Trie current = this.mTrieRoot;
            for (int k = 0; k < s.length(); ++k) {
                Character c = Character.valueOf(s.charAt(k));
                Trie next = current.children.get(c);
                if (next == null) {
                    next = new Trie();
                    current.children.put(c, next);
                }
                current = next;
            }
            current.endOfWord = true;
        }
    }

    @Override
    public String find(String input) {
        Trie current = this.mTrieRoot;
        int longestMatch = -1;
        for (int k = 0; k < input.length() && current != null; ++k) {
            if (current.endOfWord) {
                longestMatch = k;
            }
            current = current.children.get(Character.valueOf(input.charAt(k)));
        }
        if (current != null && current.endOfWord) {
            return input;
        }
        if (longestMatch > -1) {
            return input.substring(0, longestMatch);
        }
        return null;
    }

    @Override
    public boolean threadsafe() {
        return true;
    }

    static class Trie {
        TreeMap<Character, Trie> children = new TreeMap();
        boolean endOfWord = false;

        Trie() {
        }
    }
}

