/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp.impl;

import org.daisy.pipeline.nlp.TextCategorizer;

public abstract class MatchRule {
    private final int mPriority;
    private final TextCategorizer.Category mCategory;
    protected final TextCategorizer.MatchMode mMatchMode;
    protected final boolean mCaseSensitive;

    public MatchRule(TextCategorizer.Category category, int priority, boolean caseSensitive, TextCategorizer.MatchMode matchMode) {
        this.mCategory = category;
        this.mPriority = priority;
        this.mCaseSensitive = caseSensitive;
        this.mMatchMode = matchMode;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public TextCategorizer.CategorizedWord match(String input, String lowerCaseInput) {
        String res = this.mCaseSensitive ? this.match(input) : this.match(lowerCaseInput);
        if (res == null) {
            return null;
        }
        TextCategorizer.CategorizedWord cw = new TextCategorizer.CategorizedWord();
        cw.category = this.mCategory;
        cw.word = res;
        return cw;
    }

    protected abstract String match(String var1);

    public abstract boolean threadsafe();
}

