/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp;

import java.io.IOException;

public abstract class TextCategorizer {
    protected MatchMode mMatchMode = MatchMode.FULL_MATCH;

    public static boolean isProperNoun(Category c) {
        switch (c) {
            case PROPER_NOUN: 
            case PROPER_NOUN_PLACE: 
            case PROPER_NOUN_NAME: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpeakable(Category c) {
        switch (c) {
            case SPACE: 
            case PUNCTUATION: 
            case QUOTE: {
                return false;
            }
        }
        return true;
    }

    public void init(MatchMode mode) throws IOException {
        this.mMatchMode = mode;
    }

    public abstract void compile();

    public abstract void resetContext();

    public abstract boolean threadsafe();

    public abstract CategorizedWord categorize(String var1, String var2);

    public static enum MatchMode {
        FULL_MATCH,
        PREFIX_MATCH;

    }

    public static class CategorizedWord {
        public Category category;
        public String word;
    }

    public static enum Category {
        COMMON,
        UNKNOWN,
        PROPER_NOUN,
        PROPER_NOUN_PLACE,
        PROPER_NOUN_NAME,
        ABBREVIATION,
        ACRONYM,
        PUNCTUATION,
        EMAIL_ADDR,
        WEB_LINK,
        QUANTITY,
        ORDINAL,
        TIME,
        QUOTE,
        DATE,
        SPACE,
        CURRENCY,
        DIMENSIONS,
        MEASURE,
        PHONE_NUMBER,
        RANGE,
        IDENTIFIER,
        NUMBERING_ITEM;

    }
}

