/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.daisy.pipeline.nlp.TextCategorizer;
import org.daisy.pipeline.nlp.impl.MatchRule;

public abstract class RuleBasedTextCategorizer
extends TextCategorizer {
    protected ArrayList<MatchRule> mRules = new ArrayList();
    private boolean mThreadsafe = false;

    @Override
    public TextCategorizer.CategorizedWord categorize(String fullcase, String lowercase) {
        int k;
        TextCategorizer.CategorizedWord res = null;
        for (k = 0; res == null && k < this.mRules.size(); ++k) {
            res = this.mRules.get(k).match(fullcase, lowercase);
        }
        if (res == null) {
            res = new TextCategorizer.CategorizedWord();
            res.category = TextCategorizer.Category.UNKNOWN;
            res.word = fullcase.substring(0, 1);
            return res;
        }
        int priority = this.mRules.get(k - 1).getPriority();
        while (k < this.mRules.size() && this.mRules.get(k).getPriority() == priority) {
            TextCategorizer.CategorizedWord m = this.mRules.get(k).match(fullcase, lowercase);
            if (m != null && m.word.length() > res.word.length()) {
                res = m;
            }
            ++k;
        }
        return res;
    }

    @Override
    public void resetContext() {
    }

    @Override
    public boolean threadsafe() {
        return this.mThreadsafe;
    }

    protected void addRule(MatchRule rule) {
        this.mRules.add(rule);
    }

    @Override
    public void compile() {
        Collections.sort(this.mRules, new Comparator<MatchRule>(){

            @Override
            public int compare(MatchRule r1, MatchRule r2) {
                if (r1.getPriority() == r2.getPriority()) {
                    return r1 == r2 ? 0 : -1;
                }
                return r1.getPriority() > r2.getPriority() ? -1 : 1;
            }
        });
        for (MatchRule rule : this.mRules) {
            if (rule.threadsafe()) continue;
            return;
        }
        this.mThreadsafe = true;
    }
}

