/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.nlp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageUtils {
    private static Pattern localePattern = Pattern.compile("(\\p{Alpha}{2})(?:[-_](\\p{Alpha}{2}))?(?:[-_](\\p{Alnum}{1,8}))*");
    private static Set<String> RightToLeft = new HashSet<String>(Arrays.asList("yid", "ara", "jpr", "per", "fas", "peo", "heb"));

    public static Locale stringToLanguage(String lang) {
        Matcher m;
        Locale locale = null;
        if (lang != null && (m = localePattern.matcher(lang.toLowerCase())).matches()) {
            locale = new Locale(m.group(1), m.group(2) != null ? m.group(2) : "");
        }
        return locale;
    }

    public static boolean isRightToLeft(Locale l) {
        return RightToLeft.contains(l.getISO3Language());
    }

    public static String getFullStopSymbol(Locale lang) {
        return "! ";
    }

    public static String getCommaSymbol(Locale lang) {
        return ", ";
    }

    public static String getWhiteSpaceSymbol(Locale lang) {
        return " ";
    }
}

