/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.leptonica;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.leptonica.PIX;
import org.bytedeco.leptonica.presets.lept;

@Properties(inherit={lept.class})
public abstract class AbstractPIX
extends Pointer
implements Indexable {
    protected IntPointer pointer;

    public AbstractPIX(Pointer p) {
        super(p);
    }

    public static PIX create(int width, int height, int depth) {
        PIX p = org.bytedeco.leptonica.global.lept.pixCreate(width, height, depth);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createNoInit(int width, int height, int depth) {
        PIX p = org.bytedeco.leptonica.global.lept.pixCreateNoInit(width, height, depth);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createTemplate(PIX pixs) {
        PIX p = org.bytedeco.leptonica.global.lept.pixCreateTemplate(pixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createTemplateNoInit(PIX pixs) {
        PIX p = org.bytedeco.leptonica.global.lept.pixCreateTemplateNoInit(pixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createHeader(int width, int height, int depth) {
        PIX p = org.bytedeco.leptonica.global.lept.pixCreateHeader(width, height, depth);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p, true));
        }
        return p;
    }

    public static PIX create(int width, int height, int depth, Pointer data) {
        PIX p = AbstractPIX.createHeader(width, height, depth);
        p.pointer = new IntPointer(data);
        p.data(p.pointer);
        return p;
    }

    public PIX clone() {
        PIX p = org.bytedeco.leptonica.global.lept.pixClone((PIX)this);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public ByteBuffer createBuffer() {
        return this.createBuffer(0);
    }

    public ByteBuffer createBuffer(int index) {
        int h = org.bytedeco.leptonica.global.lept.pixGetHeight((PIX)this);
        int wpl = org.bytedeco.leptonica.global.lept.pixGetWpl((PIX)this);
        BytePointer data = new BytePointer((Pointer)org.bytedeco.leptonica.global.lept.pixGetData((PIX)this)).position((long)index).capacity((long)(h * wpl * 4));
        return data.asByteBuffer();
    }

    public UByteIndexer createIndexer() {
        return this.createIndexer(true);
    }

    public UByteIndexer createIndexer(boolean direct) {
        int w = org.bytedeco.leptonica.global.lept.pixGetWidth((PIX)this);
        int h = org.bytedeco.leptonica.global.lept.pixGetHeight((PIX)this);
        int d = org.bytedeco.leptonica.global.lept.pixGetDepth((PIX)this);
        int wpl = org.bytedeco.leptonica.global.lept.pixGetWpl((PIX)this);
        long[] sizes = new long[]{h, w, d / 8};
        long[] strides = new long[]{wpl * 4, d / 8, 1L};
        BytePointer data = new BytePointer((Pointer)org.bytedeco.leptonica.global.lept.pixGetData((PIX)this)).capacity((long)(h * wpl * 4));
        return UByteIndexer.create((BytePointer)data, (long[])sizes, (long[])strides, (boolean)direct);
    }

    public void destroy() {
        this.deallocate();
    }

    protected static class DestroyDeallocator
    extends PIX
    implements Pointer.Deallocator {
        boolean header = false;

        DestroyDeallocator(PIX p) {
            this(p, false);
        }

        DestroyDeallocator(PIX p, boolean header) {
            super(p);
            this.header = header;
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            if (this.header) {
                this.data(null);
            }
            org.bytedeco.leptonica.global.lept.pixDestroy(this);
            this.setNull();
        }
    }
}

