/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class FloatRawIndexer
extends FloatIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected FloatPointer pointer;
    final long base;
    final long size;

    public FloatRawIndexer(FloatPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public FloatRawIndexer(FloatPointer pointer, long[] sizes) {
        this(pointer, sizes, FloatRawIndexer.strides(sizes));
    }

    public FloatRawIndexer(FloatPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 4L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public float get(long i) {
        return RAW.getFloat(this.base + FloatRawIndexer.checkIndex(i, this.size) * 4L);
    }

    @Override
    public FloatIndexer get(long i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public FloatIndexer get(long i, long j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public float get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public FloatIndexer get(long[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, float f) {
        RAW.putFloat(this.base + FloatRawIndexer.checkIndex(i, this.size) * 4L, f);
        return this;
    }

    @Override
    public FloatIndexer put(long i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, f[offset + n]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, float f) {
        this.put(i * this.strides[0] + j, f);
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, f[offset + n]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, long k, float f) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, f);
        return this;
    }

    @Override
    public FloatIndexer put(long[] indices, float f) {
        this.put(this.index(indices), f);
        return this;
    }

    @Override
    public FloatIndexer put(long[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, f[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

