/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;

@InterfaceAudience.Private
public interface INodeAttributes {
    public byte[] getLocalNameBytes();

    public String getUserName();

    public String getGroupName();

    public FsPermission getFsPermission();

    public short getFsPermissionShort();

    public long getPermissionLong();

    public long getModificationTime();

    public long getAccessTime();

    public static abstract class SnapshotCopy
    implements INodeAttributes {
        private final byte[] name;
        private final long permission;
        private final long modificationTime;
        private final long accessTime;

        SnapshotCopy(byte[] name, PermissionStatus permissions, long modificationTime, long accessTime) {
            this.name = name;
            this.permission = INodeWithAdditionalFields.PermissionStatusFormat.toLong(permissions);
            this.modificationTime = modificationTime;
            this.accessTime = accessTime;
        }

        SnapshotCopy(INode inode) {
            this.name = inode.getLocalNameBytes();
            this.permission = inode.getPermissionLong();
            this.modificationTime = inode.getModificationTime();
            this.accessTime = inode.getAccessTime();
        }

        @Override
        public final byte[] getLocalNameBytes() {
            return this.name;
        }

        @Override
        public final String getUserName() {
            int n = (int)INodeWithAdditionalFields.PermissionStatusFormat.USER.retrieve(this.permission);
            return SerialNumberManager.INSTANCE.getUser(n);
        }

        @Override
        public final String getGroupName() {
            int n = (int)INodeWithAdditionalFields.PermissionStatusFormat.GROUP.retrieve(this.permission);
            return SerialNumberManager.INSTANCE.getGroup(n);
        }

        @Override
        public final FsPermission getFsPermission() {
            return new FsPermission(this.getFsPermissionShort());
        }

        @Override
        public final short getFsPermissionShort() {
            return (short)INodeWithAdditionalFields.PermissionStatusFormat.MODE.retrieve(this.permission);
        }

        @Override
        public long getPermissionLong() {
            return this.permission;
        }

        @Override
        public final long getModificationTime() {
            return this.modificationTime;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }
    }
}

