/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaInstance;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.RandomString;

public class MethodCall
implements Implementation.Composable {
    private static final MethodDescription CALL;
    private static final MethodDescription RUN;
    protected final MethodLocator methodLocator;
    protected final TargetHandler targetHandler;
    protected final List<ArgumentLoader.Factory> argumentLoaders;
    protected final MethodInvoker methodInvoker;
    protected final TerminationHandler terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected MethodCall(MethodLocator methodLocator, TargetHandler targetHandler, List<ArgumentLoader.Factory> argumentLoaders, MethodInvoker methodInvoker, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
        this.methodLocator = methodLocator;
        this.targetHandler = targetHandler;
        this.argumentLoaders = argumentLoaders;
        this.methodInvoker = methodInvoker;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithoutSpecifiedTarget invoke(Method method) {
        return MethodCall.invoke(new MethodDescription.ForLoadedMethod(method));
    }

    public static WithoutSpecifiedTarget invoke(Constructor<?> constructor) {
        return MethodCall.invoke(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static WithoutSpecifiedTarget invoke(MethodDescription methodDescription) {
        return MethodCall.invoke(new MethodLocator.ForExplicitMethod(methodDescription));
    }

    public static WithoutSpecifiedTarget invoke(MethodLocator methodLocator) {
        return new WithoutSpecifiedTarget(methodLocator);
    }

    public static Implementation.Composable call(Callable<?> callable) {
        return MethodCall.invoke(CALL).on(callable).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
    }

    public static Implementation.Composable run(Runnable runnable) {
        return MethodCall.invoke(RUN).on(runnable).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
    }

    public static MethodCall construct(Constructor<?> constructor) {
        return MethodCall.construct(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static MethodCall construct(MethodDescription methodDescription) {
        if (!methodDescription.isConstructor()) {
            throw new IllegalArgumentException("Not a constructor: " + methodDescription);
        }
        return new MethodCall(new MethodLocator.ForExplicitMethod(methodDescription), TargetHandler.ForConstructingInvocation.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public static MethodCall invokeSuper() {
        return new WithoutSpecifiedTarget(MethodLocator.ForInstrumentedMethod.INSTANCE).onSuper();
    }

    public MethodCall with(Object ... argument) {
        ArrayList<ArgumentLoader.Factory> argumentLoaders = new ArrayList<ArgumentLoader.Factory>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add(ArgumentLoader.ForStaticField.Factory.of(anArgument));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall with(TypeDescription ... typeDescription) {
        ArrayList<ArgumentLoader.ForClassConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForClassConstant>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentLoaders.add(new ArgumentLoader.ForClassConstant(aTypeDescription));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall with(EnumerationDescription ... enumerationDescription) {
        ArrayList<ArgumentLoader.ForEnumerationValue> argumentLoaders = new ArrayList<ArgumentLoader.ForEnumerationValue>(enumerationDescription.length);
        for (EnumerationDescription anEnumerationDescription : enumerationDescription) {
            argumentLoaders.add(new ArgumentLoader.ForEnumerationValue(anEnumerationDescription));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall with(JavaInstance ... javaInstance) {
        ArrayList<ArgumentLoader.ForJavaInstance> argumentLoaders = new ArrayList<ArgumentLoader.ForJavaInstance>(javaInstance.length);
        for (JavaInstance aJavaInstance : javaInstance) {
            argumentLoaders.add(new ArgumentLoader.ForJavaInstance(aJavaInstance));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withReference(Object ... argument) {
        ArrayList<ArgumentLoader.ForNullConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForNullConstant>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add((ArgumentLoader.ForNullConstant)(anArgument == null ? ArgumentLoader.ForNullConstant.INSTANCE : new ArgumentLoader.ForStaticField.Factory(anArgument)));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withArgument(int ... index) {
        ArrayList<ArgumentLoader.ForMethodParameter.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameter.Factory>(index.length);
        for (int anIndex : index) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Negative index: " + anIndex);
            }
            argumentLoaders.add(new ArgumentLoader.ForMethodParameter.Factory(anIndex));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withAllArguments() {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, ArgumentLoader.ForMethodParameter.OfInstrumentedMethod.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withThis() {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, ArgumentLoader.ForThisReference.Factory.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withOwnType() {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, ArgumentLoader.ForInstrumentedType.Factory.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withInstanceField(Type type, String name) {
        return this.withInstanceField(TypeDefinition.Sort.describe(type), name);
    }

    public MethodCall withInstanceField(TypeDefinition typeDefinition, String name) {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, new ArgumentLoader.ForInstanceField.Factory(typeDefinition.asGenericType(), name)), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withField(String ... fieldName) {
        ArrayList<ArgumentLoader.ForExistingField.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForExistingField.Factory>(fieldName.length);
        for (String aFieldName : fieldName) {
            argumentLoaders.add(new ArgumentLoader.ForExistingField.Factory(aFieldName));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withAssigner(Assigner assigner, Assigner.Typing typing) {
        return new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, this.terminationHandler, assigner, typing);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.ForChainedInvocation.INSTANCE, this.assigner, this.typing), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        for (ArgumentLoader.Factory argumentLoader : this.argumentLoaders) {
            instrumentedType = argumentLoader.prepare(instrumentedType);
        }
        return this.targetHandler.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodCall)) {
            return false;
        }
        MethodCall that = (MethodCall)other;
        return this.typing == that.typing && this.argumentLoaders.equals(that.argumentLoaders) && this.assigner.equals(that.assigner) && this.methodInvoker.equals(that.methodInvoker) && this.methodLocator.equals(that.methodLocator) && this.targetHandler.equals(that.targetHandler) && this.terminationHandler.equals(that.terminationHandler);
    }

    public int hashCode() {
        int result = this.methodLocator.hashCode();
        result = 31 * result + this.targetHandler.hashCode();
        result = 31 * result + this.argumentLoaders.hashCode();
        result = 31 * result + this.methodInvoker.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.typing.hashCode();
        return result;
    }

    public String toString() {
        return "MethodCall{methodLocator=" + this.methodLocator + ", targetHandler=" + this.targetHandler + ", argumentLoaders=" + this.argumentLoaders + ", methodInvoker=" + this.methodInvoker + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
    }

    static {
        try {
            CALL = new MethodDescription.ForLoadedMethod(Callable.class.getDeclaredMethod("call", new Class[0]));
            RUN = new MethodDescription.ForLoadedMethod(Runnable.class.getDeclaredMethod("run", new Class[0]));
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Cannot find standard method", exception);
        }
    }

    protected class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;

        protected Appender(Implementation.Target implementationTarget) {
            this.implementationTarget = implementationTarget;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            MethodDescription invokedMethod = MethodCall.this.methodLocator.resolve(instrumentedMethod);
            ParameterList<?> parameters = invokedMethod.getParameters();
            if (parameters.size() != MethodCall.this.argumentLoaders.size()) {
                throw new IllegalStateException(invokedMethod + " does not take " + MethodCall.this.argumentLoaders.size() + " arguments");
            }
            Iterator parameterIterator = parameters.iterator();
            ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(MethodCall.this.argumentLoaders.size());
            for (ArgumentLoader.Factory factory : MethodCall.this.argumentLoaders) {
                argumentLoaders.addAll(factory.make(this.implementationTarget.getInstrumentedType(), instrumentedMethod));
            }
            ArrayList<StackManipulation> argumentInstructions = new ArrayList<StackManipulation>(argumentLoaders.size());
            for (ArgumentLoader argumentLoader : argumentLoaders) {
                argumentInstructions.add(argumentLoader.resolve((ParameterDescription)parameterIterator.next(), MethodCall.this.assigner, MethodCall.this.typing));
            }
            StackManipulation.Size size = new StackManipulation.Compound(MethodCall.this.targetHandler.resolve(invokedMethod, instrumentedMethod, this.implementationTarget.getInstrumentedType(), MethodCall.this.assigner, MethodCall.this.typing), new StackManipulation.Compound(argumentInstructions), MethodCall.this.methodInvoker.invoke(invokedMethod, this.implementationTarget), MethodCall.this.terminationHandler.resolve(invokedMethod, instrumentedMethod, MethodCall.this.assigner, MethodCall.this.typing)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        private MethodCall getOuter() {
            return MethodCall.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.implementationTarget.equals(appender.implementationTarget) && MethodCall.this.equals(appender.getOuter());
        }

        public int hashCode() {
            return this.implementationTarget.hashCode() + 31 * MethodCall.this.hashCode();
        }

        public String toString() {
            return "MethodCall.Appender{methodCall=" + MethodCall.this + ", implementationTarget=" + this.implementationTarget + '}';
        }
    }

    public static class WithoutSpecifiedTarget
    extends MethodCall {
        protected WithoutSpecifiedTarget(MethodLocator methodLocator) {
            super(methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        public MethodCall on(Object target) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForStaticField(target), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation(target.getClass()), TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.typing);
        }

        public MethodCall onArgument(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("An argument index cannot be negative: " + index);
            }
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodParameter(index), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.typing);
        }

        public MethodCall onInstanceField(Type type, String fieldName) {
            return this.onInstanceField(TypeDefinition.Sort.describe(type), fieldName);
        }

        public MethodCall onInstanceField(TypeDescription.Generic typeDescription, String fieldName) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForInstanceField(fieldName, typeDescription), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation(typeDescription.asErasure()), TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.typing);
        }

        public MethodCall onSuper() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForSuperMethodInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.typing);
        }

        public MethodCall onDefault() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForDefaultMethodInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.typing);
        }

        @Override
        public String toString() {
            return "MethodCall.WithoutSpecifiedTarget{methodLocator=" + this.methodLocator + ", targetHandler=" + this.targetHandler + ", argumentLoaders=" + this.argumentLoaders + ", methodInvoker=" + this.methodInvoker + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
        }
    }

    protected static interface TerminationHandler {
        public StackManipulation resolve(MethodDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);

        public static enum ForChainedInvocation implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                return Removal.pop(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asErasure() : invokedMethod.getReturnType().asErasure());
            }

            public String toString() {
                return "MethodCall.TerminationHandler.ForChainedInvocation." + this.name();
            }
        }

        public static enum ForMethodReturn implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asGenericType() : invokedMethod.getReturnType(), instrumentedMethod.getReturnType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot return " + invokedMethod.getReturnType() + " from " + instrumentedMethod);
                }
                return new StackManipulation.Compound(stackManipulation, MethodReturn.returning(instrumentedMethod.getReturnType().asErasure()));
            }

            public String toString() {
                return "MethodCall.TerminationHandler.ForMethodReturn." + this.name();
            }
        }
    }

    protected static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1, Implementation.Target var2);

        public static enum ForDefaultMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isInvokableOn(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as default method of " + implementationTarget.getInstrumentedType());
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDefault(invokedMethod.getDeclaringType().asErasure(), invokedMethod.asSignatureToken());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + implementationTarget.getInstrumentedType());
                }
                return stackManipulation;
            }

            public String toString() {
                return "MethodCall.MethodInvoker.ForDefaultMethodInvocation." + this.name();
            }
        }

        public static enum ForSuperMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (implementationTarget.getInstrumentedType().getSuperClass() == null) {
                    throw new IllegalStateException("Cannot invoke super method for " + implementationTarget.getInstrumentedType());
                }
                if (!invokedMethod.isInvokableOn(implementationTarget.getOriginType().asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as super method of " + implementationTarget.getInstrumentedType());
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDominant(invokedMethod.asSignatureToken());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as a super method");
                }
                return stackManipulation;
            }

            public String toString() {
                return "MethodCall.MethodInvoker.ForSuperMethodInvocation." + this.name();
            }
        }

        public static class ForVirtualInvocation
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            protected ForVirtualInvocation(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            protected ForVirtualInvocation(Class<?> type) {
                this(new TypeDescription.ForLoadedType(type));
            }

            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isVirtual()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                }
                if (!invokedMethod.isInvokableOn(this.typeDescription.asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.typeDescription);
                }
                if (!this.typeDescription.asErasure().isVisibleTo(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException(this.typeDescription + " is not visible to " + implementationTarget.getInstrumentedType());
                }
                return MethodInvocation.invoke(invokedMethod).virtual(this.typeDescription.asErasure());
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForVirtualInvocation that = (ForVirtualInvocation)other;
                return this.typeDescription.equals(that.typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.MethodInvoker.ForVirtualInvocation{typeDescription=" + this.typeDescription + '}';
            }

            public static enum WithImplicitType implements MethodInvoker
            {
                INSTANCE;


                @Override
                public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                    if (!invokedMethod.isVirtual()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                    }
                    return MethodInvocation.invoke(invokedMethod);
                }

                public String toString() {
                    return "MethodCall.MethodInvoker.ForVirtualInvocation.WithImplicitType." + this.name();
                }
            }
        }

        public static enum ForContextualInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (invokedMethod.isVirtual() && !invokedMethod.isInvokableOn(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + implementationTarget.getInstrumentedType());
                }
                if (!invokedMethod.isVisibleTo(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException(implementationTarget.getInstrumentedType() + " cannot see " + invokedMethod);
                }
                return invokedMethod.isVirtual() ? MethodInvocation.invoke(invokedMethod).virtual(implementationTarget.getInstrumentedType()) : MethodInvocation.invoke(invokedMethod);
            }

            public String toString() {
                return "MethodCall.MethodInvoker.ForContextualInvocation." + this.name();
            }
        }
    }

    protected static interface ArgumentLoader {
        public StackManipulation resolve(ParameterDescription var1, Assigner var2, Assigner.Typing var3);

        public static class ForJavaInstance
        implements ArgumentLoader,
        Factory {
            private final JavaInstance javaInstance;

            public ForJavaInstance(JavaInstance javaInstance) {
                this.javaInstance = javaInstance;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.javaInstance.asStackManipulation(), assigner.assign(this.javaInstance.getInstanceType().asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign Class value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.javaInstance.equals(((ForJavaInstance)other).javaInstance);
            }

            public int hashCode() {
                return this.javaInstance.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForJavaInstance{javaInstance=" + this.javaInstance + '}';
            }
        }

        public static class ForEnumerationValue
        implements ArgumentLoader,
        Factory {
            private final EnumerationDescription enumerationDescription;

            protected ForEnumerationValue(EnumerationDescription enumerationDescription) {
                this.enumerationDescription = enumerationDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forEnumeration(this.enumerationDescription), assigner.assign(this.enumerationDescription.getEnumerationType().asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.enumerationDescription.getEnumerationType() + " value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.enumerationDescription.equals(((ForEnumerationValue)other).enumerationDescription);
            }

            public int hashCode() {
                return this.enumerationDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForEnumerationValue{enumerationDescription=" + this.enumerationDescription + '}';
            }
        }

        public static class ForClassConstant
        implements ArgumentLoader,
        Factory {
            private final TypeDescription typeDescription;

            protected ForClassConstant(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.typeDescription), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign class value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForClassConstant)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForClassConstant{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static class ForTextConstant
        implements ArgumentLoader,
        Factory {
            private final String value;

            protected ForTextConstant(String value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new TextConstant(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(String.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign String value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value.equals(((ForTextConstant)other).value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForTextConstant{value='" + this.value + '\'' + '}';
            }
        }

        public static class ForDoubleConstant
        implements ArgumentLoader,
        Factory {
            private final double value;

            protected ForDoubleConstant(double value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(DoubleConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Double.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign double value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Double.compare(((ForDoubleConstant)other).value, this.value) == 0;
            }

            public int hashCode() {
                long temp = Double.doubleToLongBits(this.value);
                return (int)(temp ^ temp >>> 32);
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForDoubleConstant{value=" + this.value + '}';
            }
        }

        public static class ForFloatConstant
        implements ArgumentLoader,
        Factory {
            private final float value;

            protected ForFloatConstant(float value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FloatConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Float.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign float value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Float.compare(((ForFloatConstant)other).value, this.value) == 0;
            }

            public int hashCode() {
                return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForFloatConstant{value=" + this.value + '}';
            }
        }

        public static class ForLongConstant
        implements ArgumentLoader,
        Factory {
            private final long value;

            protected ForLongConstant(long value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(LongConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Long.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign long value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForLongConstant)other).value;
            }

            public int hashCode() {
                return (int)(this.value ^ this.value >>> 32);
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForLongConstant{value=" + this.value + '}';
            }
        }

        public static class ForIntegerConstant
        implements ArgumentLoader,
        Factory {
            private final int value;

            protected ForIntegerConstant(int value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Integer.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign integer value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForIntegerConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForIntegerConstant{value=" + this.value + '}';
            }
        }

        public static class ForCharacterConstant
        implements ArgumentLoader,
        Factory {
            private final char value;

            protected ForCharacterConstant(char value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Character.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign char value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForCharacterConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForCharacterConstant{value=" + this.value + '}';
            }
        }

        public static class ForShortConstant
        implements ArgumentLoader,
        Factory {
            private final short value;

            protected ForShortConstant(short value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Short.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign short value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForShortConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForShortConstant{value=" + this.value + '}';
            }
        }

        public static class ForByteConstant
        implements ArgumentLoader,
        Factory {
            private final byte value;

            protected ForByteConstant(byte value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Byte.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign byte value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForByteConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForByteConstant{value=" + this.value + '}';
            }
        }

        public static class ForBooleanConstant
        implements ArgumentLoader,
        Factory {
            private final boolean value;

            protected ForBooleanConstant(boolean value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Boolean.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign boolean value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForBooleanConstant)other).value;
            }

            public int hashCode() {
                return this.value ? 1 : 0;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForBooleanConstant{value=" + this.value + '}';
            }
        }

        public static class ForExistingField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;
            private final MethodDescription instrumentedMethod;

            protected ForExistingField(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
                this.fieldDescription = fieldDescription;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (!this.fieldDescription.isStatic() && this.instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static " + this.fieldDescription + " from " + this.instrumentedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(this.fieldDescription).getter(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForExistingField that = (ForExistingField)object;
                if (!this.fieldDescription.equals(that.fieldDescription)) {
                    return false;
                }
                return this.instrumentedMethod.equals(that.instrumentedMethod);
            }

            public int hashCode() {
                int result = this.fieldDescription.hashCode();
                result = 31 * result + this.instrumentedMethod.hashCode();
                return result;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForExistingField{fieldDescription=" + this.fieldDescription + ", instrumentedMethod=" + this.instrumentedMethod + '}';
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final String fieldName;

                protected Factory(String fieldName) {
                    this.fieldName = fieldName;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    for (TypeDefinition currentType : instrumentedType) {
                        FieldList fieldList = (FieldList)currentType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName).and(ElementMatchers.isVisibleTo(instrumentedType)));
                        if (fieldList.size() == 0) continue;
                        return Collections.singletonList(new ForExistingField((FieldDescription)fieldList.getOnly(), instrumentedMethod));
                    }
                    throw new IllegalStateException(instrumentedType + " does not define a visible field " + this.fieldName);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Factory factory = (Factory)object;
                    return this.fieldName.equals(factory.fieldName);
                }

                public int hashCode() {
                    return this.fieldName.hashCode();
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForExistingField.Factory{fieldName='" + this.fieldName + '\'' + '}';
                }
            }
        }

        public static class ForInstanceField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;

            protected ForInstanceField(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(this.fieldDescription).getter(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForInstanceField that = (ForInstanceField)object;
                return this.fieldDescription.equals(that.fieldDescription);
            }

            public int hashCode() {
                return this.fieldDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForInstanceField{fieldDescription=" + this.fieldDescription + '}';
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final TypeDescription.Generic fieldType;
                private final String fieldName;

                protected Factory(TypeDescription.Generic fieldType, String fieldName) {
                    this.fieldType = fieldType;
                    this.fieldName = fieldName;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    if (instrumentedType.isInterface()) {
                        throw new IllegalStateException("Cannot define non-static field '" + this.fieldName + "' for " + instrumentedType);
                    }
                    return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4097, this.fieldType));
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot access instance field from static " + instrumentedMethod);
                    }
                    return Collections.singletonList(new ForInstanceField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()));
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Factory factory = (Factory)object;
                    if (!this.fieldType.equals(factory.fieldType)) {
                        return false;
                    }
                    return this.fieldName.equals(factory.fieldName);
                }

                public int hashCode() {
                    int result = this.fieldType.hashCode();
                    result = 31 * result + this.fieldName.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForInstanceField.Factory{fieldType=" + this.fieldType + ", fieldName='" + this.fieldName + '\'' + '}';
                }
            }
        }

        public static class ForStaticField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;

            protected ForStaticField(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forField(this.fieldDescription).getter(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription.getType() + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForStaticField that = (ForStaticField)object;
                return this.fieldDescription.equals(that.fieldDescription);
            }

            public int hashCode() {
                return this.fieldDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForStaticField{fieldDescription=" + this.fieldDescription + '}';
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private static final String FIELD_PREFIX = "methodCall";
                private final Object value;
                private final String fieldName;

                protected Factory(Object value) {
                    this.value = value;
                    this.fieldName = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
                }

                protected static net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory of(Object value) {
                    if (value == null) {
                        return ForNullConstant.INSTANCE;
                    }
                    if (value instanceof String) {
                        return new ForTextConstant((String)value);
                    }
                    if (value instanceof Boolean) {
                        return new ForBooleanConstant((Boolean)value);
                    }
                    if (value instanceof Byte) {
                        return new ForByteConstant((Byte)value);
                    }
                    if (value instanceof Short) {
                        return new ForShortConstant((Short)value);
                    }
                    if (value instanceof Character) {
                        return new ForCharacterConstant(((Character)value).charValue());
                    }
                    if (value instanceof Integer) {
                        return new ForIntegerConstant((Integer)value);
                    }
                    if (value instanceof Long) {
                        return new ForLongConstant((Long)value);
                    }
                    if (value instanceof Float) {
                        return new ForFloatConstant(((Float)value).floatValue());
                    }
                    if (value instanceof Double) {
                        return new ForDoubleConstant((Double)value);
                    }
                    if (value instanceof Class) {
                        return new ForClassConstant(new TypeDescription.ForLoadedType((Class)value));
                    }
                    if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                        return new ForJavaInstance(JavaInstance.MethodHandle.ofLoaded(value));
                    }
                    if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                        return new ForJavaInstance(JavaInstance.MethodType.ofLoaded(value));
                    }
                    if (value instanceof Enum) {
                        return new ForEnumerationValue(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
                    }
                    return new Factory(value);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(this.value.getClass()))).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.value));
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    return Collections.singletonList(new ForStaticField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()));
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Factory factory = (Factory)object;
                    return this.value.equals(factory.value);
                }

                public int hashCode() {
                    int result = this.value.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForStaticField.Factory{value=" + this.value + ", fieldName='" + this.fieldName + '\'' + '}';
                }
            }
        }

        public static class ForMethodParameter
        implements ArgumentLoader {
            private final int index;
            private final MethodDescription instrumentedMethod;

            protected ForMethodParameter(int index, MethodDescription instrumentedMethod) {
                this.index = index;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                ParameterDescription parameterDescription = (ParameterDescription)this.instrumentedMethod.getParameters().get(this.index);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.of(parameterDescription.getType().asErasure()).loadOffset(parameterDescription.getOffset()), assigner.assign(parameterDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + target + " for " + this.instrumentedMethod);
                }
                return stackManipulation;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForMethodParameter that = (ForMethodParameter)object;
                if (this.index != that.index) {
                    return false;
                }
                return this.instrumentedMethod.equals(that.instrumentedMethod);
            }

            public int hashCode() {
                int result = this.index;
                result = 31 * result + this.instrumentedMethod.hashCode();
                return result;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForMethodParameter{index=" + this.index + ", instrumentedMethod=" + this.instrumentedMethod + '}';
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final int index;

                protected Factory(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    if (this.index >= instrumentedMethod.getParameters().size()) {
                        throw new IllegalStateException(instrumentedMethod + " does not have a parameter with index " + this.index);
                    }
                    return Collections.singletonList(new ForMethodParameter(this.index, instrumentedMethod));
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Factory factory = (Factory)object;
                    return this.index == factory.index;
                }

                public int hashCode() {
                    return this.index;
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForMethodParameter.Factory{index=" + this.index + '}';
                }
            }

            protected static enum OfInstrumentedMethod implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        argumentLoaders.add(new ForMethodParameter(parameterDescription.getIndex(), instrumentedMethod));
                    }
                    return argumentLoaders;
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForMethodParameter.OfInstrumentedMethod." + this.name();
                }
            }
        }

        public static class ForInstrumentedType
        implements ArgumentLoader {
            private final TypeDescription instrumentedType;

            protected ForInstrumentedType(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.instrumentedType), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign Class value to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForInstrumentedType that = (ForInstrumentedType)object;
                return this.instrumentedType.equals(that.instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForInstrumentedType{instrumentedType=" + this.instrumentedType + '}';
            }

            protected static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    return Collections.singletonList(new ForInstrumentedType(instrumentedType));
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForInstrumentedType.Factory." + this.name();
                }
            }
        }

        public static class ForThisReference
        implements ArgumentLoader {
            private final TypeDescription instrumentedType;

            protected ForThisReference(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), assigner.assign(this.instrumentedType.asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.instrumentedType + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForThisReference that = (ForThisReference)object;
                return this.instrumentedType.equals(that.instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForThisReference{instrumentedType=" + this.instrumentedType + '}';
            }

            protected static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException(instrumentedMethod + " is static and cannot supply an invoker instance");
                    }
                    return Collections.singletonList(new ForThisReference(instrumentedType));
                }

                public String toString() {
                    return "MethodCall.ArgumentLoader.ForThisReference.Factory." + this.name();
                }
            }
        }

        public static enum ForNullConstant implements ArgumentLoader,
        Factory
        {
            INSTANCE;


            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (target.getType().isPrimitive()) {
                    throw new IllegalStateException("Cannot assign null to " + target);
                }
                return NullConstant.INSTANCE;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForNullConstant." + this.name();
            }
        }

        public static interface Factory {
            public InstrumentedType prepare(InstrumentedType var1);

            public List<ArgumentLoader> make(TypeDescription var1, MethodDescription var2);
        }
    }

    protected static interface TargetHandler {
        public StackManipulation resolve(MethodDescription var1, MethodDescription var2, TypeDescription var3, Assigner var4, Assigner.Typing var5);

        public InstrumentedType prepare(InstrumentedType var1);

        public static class ForMethodParameter
        implements TargetHandler {
            private final int index;

            public ForMethodParameter(int index) {
                this.index = index;
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                if (instrumentedMethod.getParameters().size() < this.index) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not have a parameter with index " + this.index);
                }
                ParameterDescription parameterDescription = (ParameterDescription)instrumentedMethod.getParameters().get(this.index);
                StackManipulation stackManipulation = assigner.assign(parameterDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + parameterDescription.getType());
                }
                return new StackManipulation.Compound(MethodVariableAccess.of(parameterDescription.getType()).loadOffset(parameterDescription.getOffset()), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.index == ((ForMethodParameter)other).index;
            }

            public int hashCode() {
                return this.index;
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForMethodParameter{index=" + this.index + '}';
            }
        }

        public static class ForInstanceField
        implements TargetHandler {
            private final String fieldName;
            private final TypeDescription.Generic fieldType;

            public ForInstanceField(String fieldName, TypeDescription.Generic fieldType) {
                this.fieldName = fieldName;
                this.fieldType = fieldType;
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter());
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                if (instrumentedType.isInterface()) {
                    throw new IllegalStateException("Cannot define non-static field '" + this.fieldName + "' on " + instrumentedType);
                }
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4097, this.fieldType));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForInstanceField)other).fieldName) && this.fieldType.equals(((ForInstanceField)other).fieldType);
            }

            public int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + this.fieldType.hashCode();
                return result;
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
            }
        }

        public static class ForStaticField
        implements TargetHandler {
            private static final String FIELD_PREFIX = "invocationTarget";
            private final Object target;
            private final String fieldName;

            public ForStaticField(Object target) {
                this.target = target;
                this.fieldName = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter();
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(this.target.getClass()))).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.target));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((ForStaticField)other).target);
            }

            public int hashCode() {
                return this.target.hashCode();
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForStaticField{target=" + this.target + ", fieldName='" + this.fieldName + '\'' + '}';
            }
        }

        public static enum ForConstructingInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(TypeCreation.of(invokedMethod.getDeclaringType().asErasure()), Duplication.SINGLE);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForConstructingInvocation." + this.name();
            }
        }

        public static enum ForSelfOrStaticInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), (StackManipulation)((Object)(invokedMethod.isConstructor() ? Duplication.SINGLE : StackManipulation.Trivial.INSTANCE)));
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForSelfOrStaticInvocation." + this.name();
            }
        }
    }

    public static interface MethodLocator {
        public MethodDescription resolve(MethodDescription var1);

        public static class ForExplicitMethod
        implements MethodLocator {
            private final MethodDescription methodDescription;

            public ForExplicitMethod(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public MethodDescription resolve(MethodDescription instrumentedMethod) {
                return this.methodDescription;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForExplicitMethod)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.MethodLocator.ForExplicitMethod{methodDescription=" + this.methodDescription + '}';
            }
        }

        public static enum ForInstrumentedMethod implements MethodLocator
        {
            INSTANCE;


            @Override
            public MethodDescription resolve(MethodDescription instrumentedMethod) {
                return instrumentedMethod;
            }

            public String toString() {
                return "MethodCall.MethodLocator.ForInstrumentedMethod." + this.name();
            }
        }
    }
}

