/*
 * Decompiled with CFR 0.152.
 */
package zipkin.finagle.http;

import com.google.auto.service.AutoService;
import com.twitter.finagle.Name;
import com.twitter.finagle.Resolver$;
import com.twitter.finagle.stats.DefaultStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.tracing.Tracer;
import com.twitter.util.Future;
import com.twitter.util.Time;
import scala.Function1;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import zipkin.finagle.ZipkinTracer;
import zipkin.finagle.ZipkinTracerFlags;
import zipkin.finagle.http.AutoValue_HttpZipkinTracer_Config;
import zipkin.finagle.http.HttpSender;
import zipkin.finagle.http.HttpZipkinTracerFlags;
import zipkin.reporter.Sender;

@AutoService(value=Tracer.class)
public final class HttpZipkinTracer
extends ZipkinTracer {
    private final HttpSender http;

    public HttpZipkinTracer() {
        this(Config.builder().build(), DefaultStatsReceiver$.MODULE$.get().scope("zipkin.http"));
    }

    HttpZipkinTracer(Config config, StatsReceiver stats) {
        this(new HttpSender(config), config, stats);
    }

    private HttpZipkinTracer(HttpSender http, Config config, StatsReceiver stats) {
        super((Sender)http, (ZipkinTracer.Config)config, stats);
        this.http = http;
    }

    public static HttpZipkinTracer create(String host2, StatsReceiver stats) {
        return new HttpZipkinTracer(Config.builder().host(host2).build(), stats);
    }

    public static HttpZipkinTracer create(Config config, StatsReceiver stats) {
        return new HttpZipkinTracer(config, stats);
    }

    public Future<BoxedUnit> close(final Time deadline) {
        return this.http.closeFuture().flatMap((Function1)new AbstractFunction1<BoxedUnit, Future<BoxedUnit>>(){

            public Future<BoxedUnit> apply(BoxedUnit v1) {
                return HttpZipkinTracer.super.close(deadline);
            }
        });
    }

    public static abstract class Config
    implements ZipkinTracer.Config {
        public static Builder builder() {
            return new AutoValue_HttpZipkinTracer_Config.Builder().hostHeader(HttpZipkinTracerFlags.hostHeader()).host(HttpZipkinTracerFlags.host()).compressionEnabled(HttpZipkinTracerFlags.compressionEnabled()).initialSampleRate(ZipkinTracerFlags.initialSampleRate());
        }

        public Builder toBuilder() {
            return new AutoValue_HttpZipkinTracer_Config.Builder(this);
        }

        abstract Name host();

        abstract String hostHeader();

        abstract boolean compressionEnabled();

        public static abstract class Builder {
            public abstract Builder host(Name var1);

            public final Builder host(String host2) {
                return this.host(Resolver$.MODULE$.eval(host2));
            }

            public abstract Builder hostHeader(String var1);

            public abstract Builder compressionEnabled(boolean var1);

            public abstract Builder initialSampleRate(float var1);

            public abstract Config build();
        }
    }
}

