/*
 * Decompiled with CFR 0.152.
 */
package zipkin.finagle.http;

import com.twitter.finagle.Http;
import com.twitter.finagle.Http$;
import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Methods;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.tracing.NullTracer;
import com.twitter.finagle.tracing.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import zipkin.finagle.FinagleSender;
import zipkin.finagle.ZipkinTracer;
import zipkin.finagle.http.HttpZipkinTracer;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Encoding;

final class HttpSender
extends FinagleSender<HttpZipkinTracer.Config, Request, Response> {
    final HttpZipkinTracer.Config config;

    HttpSender(HttpZipkinTracer.Config config) {
        super((ZipkinTracer.Config)config);
        this.config = config;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> list) {
        return Encoding.THRIFT.listSizeInBytes(list);
    }

    protected Service<Request, Response> newClient(HttpZipkinTracer.Config config) {
        Stack stack = Http$.MODULE$.client().stack().remove(new Stack.Role("TraceInitializerFilter"));
        return new Http.Client(stack, Http.Client$.MODULE$.apply$default$2()).withTracer((Tracer)new NullTracer()).newService(config.host(), "zipkin-http");
    }

    protected Request makeRequest(List<byte[]> spans) throws IOException {
        byte[] thrift = BytesMessageEncoder.THRIFT.encode(spans);
        Request request = Request.apply((Method)Methods.POST, (String)"/api/v1/spans");
        request.headerMap().add("Host", this.config.hostHeader());
        request.headerMap().add("Content-Type", "application/x-thrift");
        if (this.config.compressionEnabled()) {
            request.headerMap().add("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            try (GZIPOutputStream compressor = new GZIPOutputStream(gzipped);){
                compressor.write(thrift);
            }
            thrift = gzipped.toByteArray();
        }
        request.headerMap().add("Content-Length", String.valueOf(thrift.length));
        request.write(thrift);
        return request;
    }
}

