/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingConnection;
import brave.jms.TracingXASession;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;

final class TracingXAConnection
extends TracingConnection
implements XATopicConnection,
XAQueueConnection {
    static TracingXAConnection create(XAConnection delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingXAConnection) {
            return (TracingXAConnection)delegate;
        }
        return new TracingXAConnection(delegate, jmsTracing);
    }

    TracingXAConnection(XAConnection delegate, JmsTracing jmsTracing) {
        super((Connection)delegate, jmsTracing);
    }

    public XASession createXASession() throws JMSException {
        return TracingXASession.create(((XAConnection)this.delegate).createXASession(), this.jmsTracing);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if ((this.types & 0x10) != 16) {
            throw new IllegalStateException(this.delegate + " is not an XAQueueConnection");
        }
        XAQueueSession xats = ((XAQueueConnection)this.delegate).createXAQueueSession();
        return TracingXASession.create((XASession)xats, this.jmsTracing);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if ((this.types & 0x20) != 32) {
            throw new IllegalStateException(this.delegate + " is not an XATopicConnection");
        }
        XATopicSession xats = ((XATopicConnection)this.delegate).createXATopicSession();
        return TracingXASession.create((XASession)xats, this.jmsTracing);
    }
}

