/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.shardingjdbc.core.routing.type.TableUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TableUnits {
    private final List<TableUnit> tableUnits = new LinkedList<TableUnit>();

    public Collection<String> getDataSourceNames() {
        HashSet<String> result = new HashSet<String>(this.tableUnits.size(), 1.0f);
        for (TableUnit each : this.tableUnits) {
            result.add(each.getDataSourceName());
        }
        return result;
    }

    public Optional<TableUnit> findTableUnit(String dataSourceName, String actualTableName) {
        for (TableUnit each : this.tableUnits) {
            if (!each.getDataSourceName().equalsIgnoreCase(dataSourceName) || !each.getActualTableName().equalsIgnoreCase(actualTableName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public List<Set<String>> getActualTableNameGroups(String dataSourceName, Set<String> logicTableNames) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        for (String logicTableName : logicTableNames) {
            Set<String> actualTableNames = this.getActualTableNames(dataSourceName, logicTableName);
            if (actualTableNames.isEmpty()) continue;
            result.add(actualTableNames);
        }
        return result;
    }

    private Set<String> getActualTableNames(String dataSourceName, String logicTableName) {
        HashSet<String> result = new HashSet<String>(this.tableUnits.size(), 1.0f);
        for (TableUnit each : this.tableUnits) {
            if (!each.getDataSourceName().equalsIgnoreCase(dataSourceName) || !each.getLogicTableName().equalsIgnoreCase(logicTableName)) continue;
            result.add(each.getActualTableName());
        }
        return result;
    }

    public Map<String, Set<String>> getDataSourceLogicTablesMap(Collection<String> dataSourceNames) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String each : dataSourceNames) {
            Set<String> logicTableNames = this.getLogicTableNames(each);
            if (logicTableNames.isEmpty()) continue;
            result.put(each, logicTableNames);
        }
        return result;
    }

    private Set<String> getLogicTableNames(String dataSourceName) {
        HashSet<String> result = new HashSet<String>(this.tableUnits.size(), 1.0f);
        for (TableUnit each : this.tableUnits) {
            if (!each.getDataSourceName().equalsIgnoreCase(dataSourceName)) continue;
            result.addAll(Lists.transform(this.tableUnits, (Function)new Function<TableUnit, String>(){

                public String apply(TableUnit input) {
                    return input.getLogicTableName();
                }
            }));
        }
        return result;
    }

    public List<TableUnit> getTableUnits() {
        return this.tableUnits;
    }

    public String toString() {
        return "TableUnits(tableUnits=" + this.getTableUnits() + ")";
    }
}

