/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.TokenType;
import io.shardingjdbc.core.parsing.parser.exception.SQLParsingUnsupportedException;
import io.shardingjdbc.core.parsing.parser.sql.SQLParser;
import io.shardingjdbc.core.parsing.parser.sql.ddl.alter.AlterParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.ddl.create.CreateParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.ddl.drop.DropParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.ddl.truncate.TruncateParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.dml.delete.DeleteParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.InsertParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.dml.update.UpdateParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.tcl.TCLParserFactory;
import io.shardingjdbc.core.rule.ShardingRule;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        if (!(tokenType instanceof DefaultKeyword)) {
            throw new SQLParsingUnsupportedException(tokenType);
        }
        switch ((DefaultKeyword)tokenType) {
            case SELECT: {
                return SelectParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case INSERT: {
                return InsertParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case UPDATE: {
                return UpdateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DELETE: {
                return DeleteParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case CREATE: {
                return CreateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case ALTER: {
                return AlterParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DROP: {
                return DropParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case TRUNCATE: {
                return TruncateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case SET: 
            case COMMIT: 
            case ROLLBACK: 
            case SAVEPOINT: 
            case BEGIN: {
                return TCLParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(lexerEngine.getCurrentToken().getType());
    }

    private SQLParserFactory() {
    }
}

