/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.hint;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.HintManager;
import io.shardingjdbc.core.api.algorithm.sharding.ShardingValue;
import io.shardingjdbc.core.hint.ShardingKey;

public final class HintManagerHolder {
    public static final String DB_TABLE_NAME = "DB_TABLE_NAME";
    public static final String DB_COLUMN_NAME = "DB_COLUMN_NAME";
    private static final ThreadLocal<HintManager> HINT_MANAGER_HOLDER = new ThreadLocal();

    public static void setHintManager(HintManager hintManager) {
        Preconditions.checkState((null == HINT_MANAGER_HOLDER.get() ? 1 : 0) != 0, (Object)"HintManagerHolder has previous value, please clear first.");
        HINT_MANAGER_HOLDER.set(hintManager);
    }

    public static boolean isUseShardingHint() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isShardingHint();
    }

    public static Optional<ShardingValue> getDatabaseShardingValue(ShardingKey shardingKey) {
        return HintManagerHolder.isUseShardingHint() ? Optional.fromNullable((Object)HINT_MANAGER_HOLDER.get().getDatabaseShardingValue(shardingKey)) : Optional.absent();
    }

    public static Optional<ShardingValue> getTableShardingValue(ShardingKey shardingKey) {
        return HintManagerHolder.isUseShardingHint() ? Optional.fromNullable((Object)HINT_MANAGER_HOLDER.get().getTableShardingValue(shardingKey)) : Optional.absent();
    }

    public static boolean isMasterRouteOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isMasterRouteOnly();
    }

    public static boolean isDatabaseShardingOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isDatabaseShardingOnly();
    }

    public static void clear() {
        HINT_MANAGER_HOLDER.remove();
    }

    public static HintManager get() {
        return HINT_MANAGER_HOLDER.get();
    }

    private HintManagerHolder() {
    }
}

