/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigChangeListener;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConsulConfiguration
extends AbstractConfiguration<ConfigChangeListener> {
    private static volatile ConsulConfiguration instance;
    private static volatile ConsulClient client;
    private static final Configuration FILE_CONFIG;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String CONFIG_TYPE = "consul";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.consul.";
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static ExecutorService consulConfigExecutor;
    private static ExecutorService consulNotifierExecutor;
    private static ConcurrentMap<String, List<ConfigChangeListener>> configListenersMap;
    private static ConcurrentMap<String, List<ConfigChangeNotifier>> configChangeNotifiersMap;
    private static final int DEFAULT_WATCH_TIMEOUT = 60;
    private static final long CAS = 0L;

    private ConsulConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsulConfiguration getInstance() {
        if (null != instance) return instance;
        Class<ConsulConfiguration> clazz = ConsulConfiguration.class;
        synchronized (ConsulConfiguration.class) {
            if (null != instance) return instance;
            consulConfigExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("consul-config-executor", 1));
            consulNotifierExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("consul-notifier-executor", 1));
            configListenersMap = new ConcurrentHashMap<String, List<ConfigChangeListener>>(8);
            configChangeNotifiersMap = new ConcurrentHashMap<String, List<ConfigChangeNotifier>>(8);
            instance = new ConsulConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        consulConfigExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().getKVValue(dataId), configFuture));
        return (String)configFuture.get();
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        consulConfigExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().setKVValue(dataId, content), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        consulConfigExecutor.execute(() -> {
            PutParams putParams = new PutParams();
            putParams.setCas(Long.valueOf(0L));
            this.complete(ConsulConfiguration.getConsulClient().setKVValue(dataId, content, putParams), configFuture);
        });
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        consulConfigExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().deleteKVValue(dataId), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public void addConfigListener(String dataId, ConfigChangeListener listener) {
        configListenersMap.putIfAbsent(dataId, new ArrayList());
        configChangeNotifiersMap.putIfAbsent(dataId, new ArrayList());
        ConfigChangeNotifier configChangeNotifier = new ConfigChangeNotifier(dataId, listener);
        ((List)configChangeNotifiersMap.get(dataId)).add(configChangeNotifier);
        if (null != listener.getExecutor()) {
            listener.getExecutor().submit(configChangeNotifier);
        } else {
            consulConfigExecutor.submit(configChangeNotifier);
        }
    }

    @Override
    public void removeConfigListener(String dataId, ConfigChangeListener listener) {
        List<ConfigChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null) {
            return;
        }
        ArrayList<ConfigChangeListener> newChangeListenerList = new ArrayList<ConfigChangeListener>();
        for (ConfigChangeListener changeListener : configChangeListeners) {
            if (changeListener.equals(listener)) continue;
            newChangeListenerList.add(changeListener);
        }
        configListenersMap.put(dataId, newChangeListenerList);
        if (null != listener.getExecutor()) {
            listener.getExecutor().shutdownNow();
        }
        List configChangeNotifiers = (List)configChangeNotifiersMap.get(dataId);
        ArrayList<ConfigChangeNotifier> newConfigChangeNotifiers = new ArrayList<ConfigChangeNotifier>();
        for (ConfigChangeNotifier configChangeNotifier : configChangeNotifiers) {
            if (!listener.equals(configChangeNotifier.getListener())) {
                newConfigChangeNotifiers.add(configChangeNotifier);
                continue;
            }
            configChangeNotifier.stop();
        }
        configChangeNotifiersMap.put(dataId, newConfigChangeNotifiers);
    }

    @Override
    public List<ConfigChangeListener> getConfigListeners(String dataId) {
        return (List)configListenersMap.get(dataId);
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConsulClient getConsulClient() {
        if (null != client) return client;
        Class<ConsulConfiguration> clazz = ConsulConfiguration.class;
        synchronized (ConsulConfiguration.class) {
            if (null != client) return client;
            client = new ConsulClient(FILE_CONFIG.getConfig("config.consul.serverAddr"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private void complete(Response response, ConfigFuture configFuture) {
        Object value = response.getValue();
        if (null != response && null != value) {
            if (value instanceof GetValue) {
                configFuture.setResult(((GetValue)response.getValue()).getDecodedValue());
            } else {
                configFuture.setResult(response.getValue());
            }
        }
    }

    static {
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        consulConfigExecutor = null;
        consulNotifierExecutor = null;
        configListenersMap = null;
        configChangeNotifiersMap = null;
    }

    private static class ConfigChangeNotifier
    implements Runnable {
        private final String dataId;
        private final ConfigChangeListener listener;
        private long consulIndex;
        private boolean running;

        public ConfigChangeNotifier(String dataId, ConfigChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
            this.consulIndex = ConsulConfiguration.getConsulClient().getKVValue(this.dataId).getConsulIndex();
            this.running = true;
        }

        public ConfigChangeListener getListener() {
            return this.listener;
        }

        @Override
        public void run() {
            while (this.running) {
                this.process();
            }
        }

        private void process() {
            QueryParams queryParams = new QueryParams(60L, this.consulIndex);
            Response response = ConsulConfiguration.getConsulClient().getKVValue(this.dataId, queryParams);
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                GetValue getValue = (GetValue)response.getValue();
                this.consulIndex = currentIndex;
                for (ConfigChangeListener listener : (List)configListenersMap.get(this.dataId)) {
                    listener.receiveConfigInfo(getValue.getDecodedValue());
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

