/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.thread;

import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final String prefix;
    private final int totalSize;
    private final boolean makeDaemons;

    public NamedThreadFactory(String prefix, int totalSize, boolean makeDaemons) {
        this.prefix = prefix;
        this.makeDaemons = makeDaemons;
        this.totalSize = totalSize;
    }

    public NamedThreadFactory(String prefix, boolean makeDaemons) {
        this(prefix, 0, makeDaemons);
    }

    public NamedThreadFactory(String prefix, int totalSize) {
        this(prefix, totalSize, true);
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.prefix + "_" + this.counter.incrementAndGet();
        if (this.totalSize > 1) {
            name = name + "_" + this.totalSize;
        }
        FastThreadLocalThread thread = new FastThreadLocalThread(r, name);
        thread.setDaemon(this.makeDaemons);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

