/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.Microservices;
import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.annotations.AfterConstruct;
import io.scalecube.services.annotations.BeforeDestroy;
import io.scalecube.services.annotations.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import reactor.core.Exceptions;

final class Injector {
    private Injector() {
    }

    public static Microservices inject(Microservices microservices, Collection<Object> services) {
        services.forEach(service -> Arrays.stream(service.getClass().getDeclaredFields()).forEach(field -> Injector.injectField(microservices, field, service)));
        services.forEach(service -> Injector.processAfterConstruct(microservices, service));
        return microservices;
    }

    private static void injectField(Microservices microservices, Field field, Object service) {
        if (field.isAnnotationPresent(Inject.class) && field.getType().equals(Microservices.class)) {
            Injector.setField(field, service, microservices);
        } else if (field.isAnnotationPresent(Inject.class) && Reflect.isService(field.getType())) {
            Inject injection = field.getAnnotation(Inject.class);
            Class routerClass = injection.router();
            ServiceCall call = microservices.call();
            if (!routerClass.isInterface()) {
                call.router(routerClass);
            }
            Object targetProxy = call.api(field.getType());
            Injector.setField(field, service, targetProxy);
        }
    }

    private static void setField(Field field, Object object, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static void processAfterConstruct(Microservices microservices, Object targetInstance) {
        Injector.processMethodWithAnnotation(microservices, targetInstance, AfterConstruct.class);
    }

    public static void processBeforeDestroy(Microservices microservices, Object targetInstance) {
        Injector.processMethodWithAnnotation(microservices, targetInstance, BeforeDestroy.class);
    }

    private static <A extends Annotation> void processMethodWithAnnotation(Microservices microservices, Object targetInstance, Class<A> annotation) {
        Method[] declaredMethods = targetInstance.getClass().getDeclaredMethods();
        Arrays.stream(declaredMethods).filter(method -> method.isAnnotationPresent(annotation)).forEach(targetMethod -> {
            try {
                targetMethod.setAccessible(true);
                Object[] parameters = Arrays.stream(targetMethod.getParameters()).map(mapper -> {
                    if (mapper.getType().equals(Microservices.class)) {
                        return microservices;
                    }
                    if (Reflect.isService(mapper.getType())) {
                        return microservices.call().api(mapper.getType());
                    }
                    return null;
                }).toArray();
                targetMethod.invoke(targetInstance, parameters);
            }
            catch (Exception ex) {
                throw Exceptions.propagate((Throwable)ex);
            }
        });
    }
}

