/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.header;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.PacketIdProvider;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;
import io.r2dbc.mssql.util.Assert;
import java.util.Objects;

public class Header
implements HeaderOptions {
    public static final int LENGTH = 8;
    private final Type type;
    private final Status status;
    private final short length;
    private final short spid;
    private final byte packetId;
    private final byte window;

    public Header(Type type, Status status, int length, int spid) {
        this(type, status, (short)length, (short)spid, 0, 0);
    }

    public Header(Type type, Status status, int length, int spid, int packetId, int window) {
        this(type, status, (short)length, (short)spid, (byte)packetId, (byte)window);
    }

    public Header(Type type, Status status, short length, short spid, byte packetId, byte window) {
        Assert.requireNonNull(type, "Type must not be null");
        Assert.requireNonNull(status, "sStatus must not be null");
        Assert.isTrue(length >= 8, "Header length must be greater or equal to 8");
        this.type = type;
        this.status = status;
        this.length = length;
        this.spid = spid;
        this.packetId = packetId;
        this.window = window;
    }

    public static Header create(HeaderOptions options, int length, PacketIdProvider packetIdProvider) {
        Assert.requireNonNull(options, "HeaderOptions must not be null");
        Assert.requireNonNull(packetIdProvider, "PacketIdProvider must not be null");
        return new Header(options.getType(), options.getStatus(), length, 0, (int)packetIdProvider.nextPacketId(), 0);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean is(Status.StatusBit bit) {
        return this.status.is(bit);
    }

    public short getSpid() {
        return this.spid;
    }

    public byte getPacketId() {
        return this.packetId;
    }

    public byte getWindow() {
        return this.window;
    }

    public short getLength() {
        return this.length;
    }

    public void encode(ByteBuf buffer) {
        Header.encode(buffer, this.type, this.status, this.length, this.spid, this.packetId, this.window);
    }

    public void encode(ByteBuf buffer, PacketIdProvider packetIdProvider) {
        Header.encode(buffer, this.type, this.status, this.length, this.spid, packetIdProvider.nextPacketId(), this.window);
    }

    public static void encode(ByteBuf buffer, HeaderOptions options, int length, PacketIdProvider packetIdProvider) {
        Header.encode(buffer, options.getType(), options.getStatus(), length, (short)0, packetIdProvider.nextPacketId(), (byte)0);
    }

    public static void encode(ByteBuf buffer, Type type, Status status, int length, short spid, byte packetId, byte window) {
        buffer.ensureWritable(8);
        buffer.writeByte((int)type.getValue());
        buffer.writeByte((int)status.getValue());
        buffer.writeShort(length);
        buffer.writeShort((int)spid);
        buffer.writeByte((int)packetId);
        buffer.writeByte((int)window);
    }

    public static boolean canDecode(ByteBuf buffer) {
        return buffer.readableBytes() >= 8;
    }

    public static Header decode(ByteBuf buffer) {
        Type type = Type.valueOf(buffer.readByte());
        Status status = Status.fromBitmask(buffer.readByte());
        short length = buffer.readShort();
        short spid = buffer.readShort();
        byte packetId = buffer.readByte();
        byte window = buffer.readByte();
        return new Header(type, status, length, spid, packetId, window);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header header = (Header)o;
        return this.length == header.length && this.spid == header.spid && this.packetId == header.packetId && this.window == header.window && this.type == header.type && Objects.equals(this.status, header.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.status, this.length, this.spid, this.packetId, this.window});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append((Object)this.type);
        sb.append(", status=").append(this.status);
        sb.append(", length=").append(this.length);
        sb.append(", spid=").append(this.spid);
        sb.append(", packetId=").append(this.packetId);
        sb.append(", window=").append(this.window);
        sb.append(']');
        return sb.toString();
    }
}

