/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client.ssl;

import io.r2dbc.mssql.client.ssl.HostNamePredicate;
import io.r2dbc.mssql.client.ssl.TdsSslHandler;
import io.r2dbc.mssql.client.ssl.X509CertificateUtil;
import java.net.IDN;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.net.ssl.X509TrustManager;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public final class ExpectedHostnameX509TrustManager
implements X509TrustManager {
    private static final Logger logger = Loggers.getLogger(TdsSslHandler.class);
    private final X509TrustManager defaultTrustManager;
    private final String expectedHostName;
    private final Predicate<String> matcher;

    public ExpectedHostnameX509TrustManager(X509TrustManager tm, String expectedHostName) {
        this.defaultTrustManager = tm;
        this.expectedHostName = expectedHostName;
        this.matcher = HostNamePredicate.of(expectedHostName);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (logger.isDebugEnabled()) {
            logger.debug("Forwarding ClientTrusted");
        }
        this.defaultTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (logger.isDebugEnabled()) {
            logger.debug("Forwarding ServerTrusted");
        }
        this.defaultTrustManager.checkServerTrusted(chain, authType);
        if (logger.isDebugEnabled()) {
            logger.debug("ServerTrusted succeeded proceeding with server name validation");
        }
        this.validateServerNameInCertificate(chain[0]);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private void validateServerNameInCertificate(X509Certificate cert) throws CertificateException {
        boolean isServerNameValidated;
        String subjectCN = X509CertificateUtil.getHostName(cert);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Expecting server name: [%s]", this.expectedHostName));
            logger.debug(String.format("Name in certificate: [%s]", subjectCN));
        }
        if (!(isServerNameValidated = this.validateServerName(subjectCN))) {
            String subjectAlternativeName;
            List<String> subjectAlternativeNames = X509CertificateUtil.getSubjectAlternativeNames(cert);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Expecting server name validation failed. Checking alternative names (SAN) [%s]", subjectAlternativeNames));
            }
            Iterator<String> iterator = subjectAlternativeNames.iterator();
            while (iterator.hasNext() && !(isServerNameValidated = this.validateServerName(subjectAlternativeName = iterator.next()))) {
            }
        }
        if (!isServerNameValidated) {
            throw new CertificateException(String.format("Cannot validate certificate: %s", subjectCN));
        }
    }

    private boolean validateServerName(@Nullable String nameInCert) {
        boolean matches;
        if (null == nameInCert) {
            return false;
        }
        if (nameInCert.startsWith("xn--")) {
            nameInCert = IDN.toUnicode(nameInCert);
        }
        if (matches = this.matcher.test(nameInCert)) {
            this.logSuccessMessage(nameInCert);
        } else {
            this.logFailMessage(nameInCert);
        }
        return matches;
    }

    private void logFailMessage(String nameInCert) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("The name in certificate [%s] does not match with the server name [%s].", nameInCert, this.expectedHostName));
        }
    }

    private void logSuccessMessage(String nameInCert) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("The name in certificate [%s] validated against server name [%s].", nameInCert, this.expectedHostName));
        }
    }
}

