/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.util.Assert;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import reactor.util.annotation.Nullable;

class Binding {
    private final Map<String, RpcParameter> parameters = new LinkedHashMap<String, RpcParameter>();
    private boolean hasOutParameters = false;
    @Nullable
    private volatile String formalRepresentation;

    Binding() {
    }

    public Binding add(String name, RpcDirection direction, Encoded parameter) {
        Assert.requireNonNull(name, "Name must not be null");
        Assert.requireNonNull(direction, "RpcDirection must not be null");
        Assert.requireNonNull(parameter, "Parameter must not be null");
        this.formalRepresentation = null;
        this.parameters.put(name, new RpcParameter(direction, parameter));
        if (direction == RpcDirection.OUT) {
            this.hasOutParameters = true;
        }
        return this;
    }

    boolean hasOutParameters() {
        return this.hasOutParameters;
    }

    void clear() {
        this.parameters.forEach((? super K s, ? super V parameter) -> {
            while (parameter.encoded.refCnt() > 0) {
                parameter.encoded.release();
            }
        });
        this.parameters.clear();
    }

    public String getFormalParameters() {
        String formalRepresentation = this.formalRepresentation;
        if (formalRepresentation != null) {
            return formalRepresentation;
        }
        StringBuilder builder = new StringBuilder(this.parameters.size() * 16);
        Set<Map.Entry<String, RpcParameter>> entries = this.parameters.entrySet();
        for (Map.Entry<String, RpcParameter> entry : entries) {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append('@').append(entry.getKey()).append(' ').append(entry.getValue().encoded.getFormalType());
            if (entry.getValue().rpcDirection != RpcDirection.OUT) continue;
            builder.append(" OUTPUT");
        }
        this.formalRepresentation = formalRepresentation = builder.toString();
        return formalRepresentation;
    }

    public void forEach(BiConsumer<String, RpcParameter> action) {
        Assert.requireNonNull(action, "Action must not be null");
        this.parameters.forEach(action);
    }

    Map<String, RpcParameter> getParameters() {
        return this.parameters;
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    int size() {
        return this.parameters.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding that = (Binding)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [parameters=").append(this.parameters);
        sb.append(']');
        return sb.toString();
    }

    public static class RpcParameter {
        final RpcDirection rpcDirection;
        final Encoded encoded;

        public RpcParameter(RpcDirection rpcDirection, Encoded encoded) {
            this.rpcDirection = rpcDirection;
            this.encoded = encoded;
        }
    }
}

