/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.publisher.DefaultTestPublisher;

public abstract class TestPublisher<T>
implements Publisher<T> {
    public static <T> TestPublisher<T> create() {
        return new DefaultTestPublisher();
    }

    public static <T> TestPublisher<T> createNoncompliant(Violation first, Violation ... rest) {
        return new DefaultTestPublisher(first, rest);
    }

    public abstract Flux<T> flux();

    public abstract Mono<T> mono();

    public abstract TestPublisher<T> assertMinRequested(long var1);

    public abstract TestPublisher<T> assertSubscribers();

    public abstract TestPublisher<T> assertSubscribers(int var1);

    public abstract TestPublisher<T> assertNoSubscribers();

    public abstract TestPublisher<T> assertCancelled();

    public abstract TestPublisher<T> assertCancelled(int var1);

    public abstract TestPublisher<T> assertNotCancelled();

    public abstract TestPublisher<T> assertRequestOverflow();

    public abstract TestPublisher<T> assertNoRequestOverflow();

    public abstract TestPublisher<T> next(T var1);

    public abstract TestPublisher<T> error(Throwable var1);

    public abstract TestPublisher<T> complete();

    @SafeVarargs
    public final TestPublisher<T> next(T first, T ... rest) {
        Objects.requireNonNull(rest, "rest array is null, please cast to T if null T required");
        this.next(first);
        for (T t : rest) {
            this.next(t);
        }
        return this;
    }

    @SafeVarargs
    public final TestPublisher<T> emit(T ... values) {
        Objects.requireNonNull(values, "values array is null, please cast to T if null T required");
        for (T t : values) {
            this.next(t);
        }
        return this.complete();
    }

    public static enum Violation {
        REQUEST_OVERFLOW,
        ALLOW_NULL,
        CLEANUP_ON_TERMINATE;

    }
}

