/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.test.DefaultStepVerifierBuilder;
import reactor.test.scheduler.VirtualTimeScheduler;

public interface StepVerifier {
    public static <T> FirstStep<T> create(Publisher<? extends T> publisher) {
        return StepVerifier.create(publisher, Long.MAX_VALUE);
    }

    public static <T> FirstStep<T> create(Publisher<? extends T> publisher, long n) {
        return DefaultStepVerifierBuilder.newVerifier(n, () -> publisher, null);
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier) {
        return StepVerifier.withVirtualTime(scenarioSupplier, Long.MAX_VALUE);
    }

    @Deprecated
    public static <T> FirstStep<T> withVirtualTime(long n, Supplier<? extends Publisher<? extends T>> scenarioSupplier) {
        return StepVerifier.withVirtualTime(scenarioSupplier, () -> VirtualTimeScheduler.enable(false), n);
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier, long n) {
        return StepVerifier.withVirtualTime(scenarioSupplier, () -> VirtualTimeScheduler.enable(false), n);
    }

    public static <T> FirstStep<T> withVirtualTime(long n, Supplier<? extends Publisher<? extends T>> scenarioSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup) {
        DefaultStepVerifierBuilder.checkPositive(n);
        Objects.requireNonNull(scenarioSupplier, "scenarioSupplier");
        Objects.requireNonNull(vtsLookup, "vtsLookup");
        return DefaultStepVerifierBuilder.newVerifier(n, scenarioSupplier, vtsLookup);
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup, long n) {
        DefaultStepVerifierBuilder.checkPositive(n);
        Objects.requireNonNull(scenarioSupplier, "scenarioSupplier");
        Objects.requireNonNull(vtsLookup, "vtsLookup");
        return DefaultStepVerifierBuilder.newVerifier(n, scenarioSupplier, vtsLookup);
    }

    public StepVerifier log();

    public Duration verify() throws AssertionError;

    public Duration verify(Duration var1) throws AssertionError;

    public static interface FirstStep<T>
    extends Step<T> {
        public Step<T> consumeSubscriptionWith(Consumer<? super Subscription> var1);

        public Step<T> expectFusion();

        public Step<T> expectFusion(int var1);

        public Step<T> expectFusion(int var1, int var2);

        public Step<T> expectNoFusionSupport();

        @Override
        public FirstStep<T> expectNoEvent(Duration var1);

        public Step<T> expectSubscription();

        public Step<T> expectSubscriptionMatches(Predicate<? super Subscription> var1);
    }

    public static interface Step<T>
    extends LastStep {
        public Step<T> as(String var1);

        public Step<T> consumeNextWith(Consumer<? super T> var1);

        default public Step<T> assertNext(Consumer<? super T> assertionConsumer) {
            return this.consumeNextWith(assertionConsumer);
        }

        public Step<T> consumeRecordedWith(Consumer<? super Collection<T>> var1);

        public Step<T> expectNext(T ... var1);

        public Step<T> expectNextCount(long var1);

        public Step<T> expectNextSequence(Iterable<? extends T> var1);

        public Step<T> expectNextMatches(Predicate<? super T> var1);

        public Step<T> expectNoEvent(Duration var1);

        public Step<T> expectRecordedMatches(Predicate<? super Collection<T>> var1);

        public Step<T> recordWith(Supplier<? extends Collection<T>> var1);

        public Step<T> then(Runnable var1);

        default public Step<T> thenAwait() {
            return this.thenAwait(Duration.ZERO);
        }

        public Step<T> thenAwait(Duration var1);

        public Step<T> thenConsumeWhile(Predicate<T> var1);

        public Step<T> thenConsumeWhile(Predicate<T> var1, Consumer<T> var2);

        public Step<T> thenRequest(long var1);
    }

    public static interface LastStep {
        public StepVerifier consumeErrorWith(Consumer<Throwable> var1);

        public StepVerifier expectError();

        public StepVerifier expectError(Class<? extends Throwable> var1);

        public StepVerifier expectErrorMessage(String var1);

        public StepVerifier expectErrorMatches(Predicate<Throwable> var1);

        public StepVerifier expectComplete();

        public StepVerifier thenCancel();

        public Duration verifyError();

        public Duration verifyError(Class<? extends Throwable> var1);

        public Duration verifyErrorMessage(String var1);

        public Duration verifyErrorMatches(Predicate<Throwable> var1);

        public Duration verifyComplete();
    }
}

