/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.test.StepVerifier;
import reactor.test.scheduler.VirtualTimeScheduler;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultStepVerifierBuilder<T>
implements StepVerifier.FirstStep<T> {
    final List<Event<T>> script;
    final long initialRequest;
    final Supplier<? extends VirtualTimeScheduler> vtsLookup;
    final Supplier<? extends Publisher<? extends T>> sourceSupplier;
    int requestedFusionMode = -1;
    int expectedFusionMode = -1;
    static final SignalEvent DEFAULT_ONSUBSCRIBE_STEP = DefaultStepVerifierBuilder.newOnSubscribeStep("defaultOnSubscribe");
    static final AtomicReferenceFieldUpdater<DefaultVerifySubscriber, Throwable> ERRORS = AtomicReferenceFieldUpdater.newUpdater(DefaultVerifySubscriber.class, Throwable.class, "errors");
    static final AtomicIntegerFieldUpdater<DefaultVerifySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(DefaultVerifySubscriber.class, "wip");
    static final Optional<AssertionError> EXPECT_MORE = Optional.of(new AssertionError((Object)"EXPECT MORE"));

    static void checkPositive(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("'n' should be >= 0 but was " + n);
        }
    }

    static void checkStrictlyPositive(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("'n' should be > 0 but was " + n);
        }
    }

    static <T> StepVerifier.FirstStep<T> newVerifier(long n, Supplier<? extends Publisher<? extends T>> scenarioSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup) {
        DefaultStepVerifierBuilder.checkPositive(n);
        Objects.requireNonNull(scenarioSupplier, "scenarioSupplier");
        return new DefaultStepVerifierBuilder<T>(n, scenarioSupplier, vtsLookup);
    }

    static <T> SignalEvent<T> defaultFirstStep() {
        return DEFAULT_ONSUBSCRIBE_STEP;
    }

    DefaultStepVerifierBuilder(long initialRequest, Supplier<? extends Publisher<? extends T>> sourceSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup) {
        this.initialRequest = initialRequest;
        this.vtsLookup = vtsLookup;
        this.sourceSupplier = sourceSupplier;
        this.script = new ArrayList<Event<T>>();
        this.script.add(DefaultStepVerifierBuilder.defaultFirstStep());
    }

    @Override
    public DefaultStepVerifierBuilder<T> as(String description) {
        this.script.add(new DescriptionEvent(description));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> consumeErrorWith(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(); actual: %s", signal);
            }
            consumer.accept(signal.getThrowable());
            return Optional.empty();
        }, "consumeErrorWith");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeNextWith(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onNext(); actual: %s", signal);
            }
            consumer.accept(signal.get());
            return Optional.empty();
        }, "consumeNextWith");
        this.script.add(event);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeRecordedWith(Consumer<? super Collection<T>> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.script.add(new CollectEvent(consumer, "consumeRecordedWith"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeSubscriptionWith(Consumer<? super Subscription> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.script.set(0, new SignalEvent((signal, se) -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onSubscribe(); actual: %s", signal);
            }
            consumer.accept(signal.getSubscription());
            return Optional.empty();
        }, "consumeSubscriptionWith"));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> expectComplete() {
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnComplete()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onComplete(); actual: %s", signal);
            }
            return Optional.empty();
        }, "expectComplete");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectError() {
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(); actual: %s", signal);
            }
            return Optional.empty();
        }, "expectError()");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectError(Class<? extends Throwable> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(%s); actual: %s", clazz.getSimpleName(), signal);
            }
            if (!clazz.isInstance(signal.getThrowable())) {
                return DefaultStepVerifierBuilder.fail(se, "expected error of type: %s; actual type: %s", clazz.getSimpleName(), signal.getThrowable());
            }
            return Optional.empty();
        }, "expectError(Class)");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorMessage(String errorMessage) {
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(\"%s\"); actual: %s", errorMessage, signal);
            }
            if (!Objects.equals(errorMessage, signal.getThrowable().getMessage())) {
                return DefaultStepVerifierBuilder.fail(se, "expected error message: \"%s\"; actual message: %s", errorMessage, signal.getThrowable().getMessage());
            }
            return Optional.empty();
        }, "expectErrorMessage");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorMatches(Predicate<Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(); actual: %s", signal);
            }
            if (!predicate.test(signal.getThrowable())) {
                return DefaultStepVerifierBuilder.fail(se, "predicate failed on exception: %s", signal.getThrowable());
            }
            return Optional.empty();
        }, "expectErrorMatches");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoFusionSupport() {
        return this.expectFusion(3, 0);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion() {
        return this.expectFusion(3, 3);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion(int requested) {
        return this.expectFusion(requested, requested);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion(int requested, int expected) {
        DefaultStepVerifierBuilder.checkPositive(requested);
        DefaultStepVerifierBuilder.checkPositive(expected);
        this.requestedFusionMode = requested;
        this.expectedFusionMode = expected;
        return this;
    }

    @Override
    @SafeVarargs
    public final DefaultStepVerifierBuilder<T> expectNext(T ... ts) {
        Objects.requireNonNull(ts, "ts");
        for (Object t : ts) {
            SignalEvent event = new SignalEvent((signal, se) -> {
                if (!signal.isOnNext()) {
                    return DefaultStepVerifierBuilder.fail(se, "expected: onNext(%s); actual: %s", t, signal);
                }
                if (!Objects.equals(t, signal.get())) {
                    return DefaultStepVerifierBuilder.fail(se, "expected value: %s; actual value: %s", t, signal.get());
                }
                return Optional.empty();
            }, String.format("expectNext(%s)", t));
            this.script.add(event);
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextSequence(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        this.script.add(new SignalSequenceEvent<T>(iterable, "expectNextSequence"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextCount(long count) {
        DefaultStepVerifierBuilder.checkPositive(count);
        this.script.add(new SignalCountEvent(count, "expectNextCount"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextMatches(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onNext(); actual: %s", signal);
            }
            if (!predicate.test(signal.get())) {
                return DefaultStepVerifierBuilder.fail(se, "predicate failed on value: %s", signal.get());
            }
            return Optional.empty();
        }, "expectNextMatches");
        this.script.add(event);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectRecordedMatches(Predicate<? super Collection<T>> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.add(new CollectEvent(predicate, "expectRecordedMatches"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectSubscription() {
        if (this.script.get(0) instanceof NoEvent) {
            this.script.add(DefaultStepVerifierBuilder.defaultFirstStep());
        } else {
            this.script.set(0, DefaultStepVerifierBuilder.newOnSubscribeStep("expectSubscription"));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectSubscriptionMatches(Predicate<? super Subscription> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.set(0, new SignalEvent((signal, se) -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onSubscribe(); actual: %s", signal);
            }
            if (!predicate.test(signal.getSubscription())) {
                return DefaultStepVerifierBuilder.fail(se, "predicate failed on subscription: %s", signal.getSubscription());
            }
            return Optional.empty();
        }, "expectSubscriptionMatches"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoEvent(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        if (this.script.size() == 1 && this.script.get(0) == DefaultStepVerifierBuilder.defaultFirstStep()) {
            this.script.set(0, new NoEvent(duration, "expectNoEvent"));
        } else {
            this.script.add(new NoEvent(duration, "expectNoEvent"));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> recordWith(Supplier<? extends Collection<T>> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        this.script.add(new CollectEvent(supplier, "recordWith"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> then(Runnable task) {
        Objects.requireNonNull(task, "task");
        this.script.add(new TaskEvent(task, "then"));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> thenCancel() {
        this.script.add(new SubscriptionEvent("thenCancel"));
        return this.build();
    }

    @Override
    public Duration verifyError() {
        return ((DefaultStepVerifier)this.expectError()).verify();
    }

    @Override
    public Duration verifyError(Class<? extends Throwable> clazz) {
        return ((DefaultStepVerifier)this.expectError((Class)clazz)).verify();
    }

    @Override
    public Duration verifyErrorMessage(String errorMessage) {
        return ((DefaultStepVerifier)this.expectErrorMessage(errorMessage)).verify();
    }

    @Override
    public Duration verifyErrorMatches(Predicate<Throwable> predicate) {
        return ((DefaultStepVerifier)this.expectErrorMatches((Predicate)predicate)).verify();
    }

    @Override
    public Duration verifyComplete() {
        return ((DefaultStepVerifier)this.expectComplete()).verify();
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenRequest(long n) {
        DefaultStepVerifierBuilder.checkStrictlyPositive(n);
        this.script.add(new RequestEvent(n, "thenRequest"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenAwait() {
        return this.thenAwait(Duration.ZERO);
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenAwait(Duration timeshift) {
        Objects.requireNonNull(timeshift, "timeshift");
        this.script.add(new WaitEvent(timeshift, "thenAwait"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenConsumeWhile(Predicate<T> predicate) {
        return this.thenConsumeWhile((Predicate)predicate, t -> {});
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenConsumeWhile(Predicate<T> predicate, Consumer<T> consumer) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.add(new SignalConsumeWhileEvent<T>(predicate, consumer, "thenConsumeWhile"));
        return this;
    }

    final DefaultStepVerifier<T> build() {
        return new DefaultStepVerifier(this);
    }

    static void virtualOrRealWait(Duration duration, DefaultVerifySubscriber<?> s) throws Exception {
        if (s.virtualTimeScheduler == null) {
            s.completeLatch.await(duration.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            s.virtualTimeScheduler.advanceTimeBy(duration);
        }
    }

    static Optional<AssertionError> fail(Event<?> event, String msg, Object ... args) {
        String prefix = "expectation failed (";
        if (event != null && event.getDescription() != null) {
            prefix = String.format("expectation \"%s\" failed (", event.getDescription());
        }
        return DefaultStepVerifierBuilder.failPrefix(prefix, msg, args);
    }

    static Optional<AssertionError> failPrefix(String prefix, String msg, Object ... args) {
        return Optional.of(new AssertionError((Object)(prefix + String.format(msg, args) + ")")));
    }

    static String formatFusionMode(int m) {
        switch (m) {
            case 3: {
                return "(any)";
            }
            case 1: {
                return "(sync)";
            }
            case 2: {
                return "(async)";
            }
            case 0: {
                return "none";
            }
            case 4: {
                return "(thread-barrier)";
            }
        }
        return "" + m;
    }

    static <T> SignalEvent<T> newOnSubscribeStep(String desc) {
        return new SignalEvent((signal, se) -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onSubscribe(); actual: %s", signal);
            }
            return Optional.empty();
        }, desc);
    }

    static final class DescriptionEvent<T>
    implements Event<T> {
        final String description;

        public DescriptionEvent(String description) {
            this.description = description;
        }

        @Override
        public boolean setDescription(String description) {
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static final class SignalConsumeWhileEvent<T>
    extends AbstractSignalEvent<T> {
        private final Predicate<T> predicate;
        private final Consumer<T> consumer;

        SignalConsumeWhileEvent(Predicate<T> predicate, Consumer<T> consumer, String desc) {
            super(desc);
            this.predicate = predicate;
            this.consumer = consumer;
        }

        boolean test(T actual) {
            if (this.predicate.test(actual)) {
                this.consumer.accept(actual);
                return true;
            }
            return false;
        }
    }

    static final class SignalSequenceEvent<T>
    extends AbstractSignalEvent<T> {
        final Iterable<? extends T> iterable;

        SignalSequenceEvent(Iterable<? extends T> iterable, String desc) {
            super(desc);
            this.iterable = iterable;
        }

        Optional<AssertionError> test(Signal<T> signal, Iterator<? extends T> iterator) {
            if (signal.isOnNext()) {
                if (!iterator.hasNext()) {
                    return Optional.empty();
                }
                T d2 = iterator.next();
                if (!Objects.equals(signal.get(), d2)) {
                    return DefaultStepVerifierBuilder.fail(this, "expected : onNext(%s); actual: %s; iterable: %s", d2, signal.get(), this.iterable);
                }
                return iterator.hasNext() ? EXPECT_MORE : Optional.empty();
            }
            if (iterator != null && iterator.hasNext() || signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(this, "expected next value: %s; actual signal: %s; iterable: %s", iterator != null && iterator.hasNext() ? iterator.next() : "none", signal, this.iterable);
            }
            return Optional.empty();
        }
    }

    static final class SubscriptionTaskEvent<T>
    extends TaskEvent<T> {
        final SubscriptionEvent<T> delegate;

        SubscriptionTaskEvent(SubscriptionEvent<T> subscriptionEvent) {
            super(null, subscriptionEvent.getDescription());
            this.delegate = subscriptionEvent;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (this.delegate.isTerminal()) {
                parent.doCancel();
            } else {
                this.delegate.consume(parent.upstream());
            }
        }
    }

    static final class WaitEvent<T>
    extends TaskEvent<T> {
        final Duration duration;

        WaitEvent(Duration duration, String desc) {
            super(null, desc);
            this.duration = duration;
        }

        @Override
        void run(DefaultVerifySubscriber<T> s) throws Exception {
            DefaultStepVerifierBuilder.virtualOrRealWait(this.duration, s);
        }
    }

    static final class NoEvent<T>
    extends TaskEvent<T> {
        final Duration duration;

        NoEvent(Duration duration, String desc) {
            super(null, desc);
            this.duration = duration;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (parent.virtualTimeScheduler != null) {
                parent.monitorSignal = true;
                DefaultStepVerifierBuilder.virtualOrRealWait(this.duration.minus(Duration.ofNanos(1L)), parent);
                parent.monitorSignal = false;
                if (parent.isTerminated() && !parent.isCancelled()) {
                    throw new AssertionError((Object)"unexpected end during a no-event expectation");
                }
                DefaultStepVerifierBuilder.virtualOrRealWait(Duration.ofNanos(1L), parent);
            } else {
                parent.monitorSignal = true;
                DefaultStepVerifierBuilder.virtualOrRealWait(this.duration, parent);
                parent.monitorSignal = false;
                if (parent.isTerminated() && !parent.isCancelled()) {
                    throw new AssertionError((Object)"unexpected end during a no-event expectation");
                }
            }
        }
    }

    static class TaskEvent<T>
    extends AbstractEagerEvent<T> {
        final Runnable task;

        TaskEvent(Runnable task, String desc) {
            super(desc);
            this.task = task;
        }

        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            this.task.run();
        }
    }

    static final class CollectEvent<T>
    extends AbstractEagerEvent<T> {
        final Supplier<? extends Collection<T>> supplier;
        final Predicate<? super Collection<T>> predicate;
        final Consumer<? super Collection<T>> consumer;

        CollectEvent(Supplier<? extends Collection<T>> supplier, String desc) {
            super(desc);
            this.supplier = supplier;
            this.predicate = null;
            this.consumer = null;
        }

        CollectEvent(Consumer<? super Collection<T>> consumer, String desc) {
            super(desc);
            this.supplier = null;
            this.predicate = null;
            this.consumer = consumer;
        }

        CollectEvent(Predicate<? super Collection<T>> predicate, String desc) {
            super(desc);
            this.supplier = null;
            this.predicate = predicate;
            this.consumer = null;
        }

        Collection<T> get() {
            return this.supplier != null ? this.supplier.get() : null;
        }

        Optional<AssertionError> test(Collection<T> collection) {
            if (this.predicate != null) {
                if (!this.predicate.test(collection)) {
                    return DefaultStepVerifierBuilder.fail(this, "expected collection predicate match; actual: %s", collection);
                }
                return Optional.empty();
            }
            if (this.consumer != null) {
                this.consumer.accept(collection);
            }
            return Optional.empty();
        }
    }

    static final class SignalCountEvent<T>
    extends AbstractSignalEvent<T> {
        final long count;

        SignalCountEvent(long count, String desc) {
            super(desc);
            this.count = count;
        }
    }

    static final class SignalEvent<T>
    extends AbstractSignalEvent<T> {
        final BiFunction<Signal<T>, SignalEvent<T>, Optional<AssertionError>> function;

        SignalEvent(BiFunction<Signal<T>, SignalEvent<T>, Optional<AssertionError>> function, String desc) {
            super(desc);
            this.function = function;
        }

        Optional<AssertionError> test(Signal<T> signal) {
            return this.function.apply(signal, this);
        }
    }

    static abstract class AbstractSignalEvent<T>
    implements Event<T> {
        String description;

        public AbstractSignalEvent(String description) {
            this.description = description;
        }

        @Override
        public boolean setDescription(String description) {
            this.description = description;
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static final class RequestEvent<T>
    extends SubscriptionEvent<T> {
        final long requestAmount;

        RequestEvent(long n, String desc) {
            super(s -> s.request(n), desc);
            this.requestAmount = n;
        }

        public long getRequestAmount() {
            return this.requestAmount;
        }

        public boolean isBounded() {
            return this.requestAmount >= 0L && this.requestAmount < Long.MAX_VALUE;
        }
    }

    static class SubscriptionEvent<T>
    extends AbstractEagerEvent<T> {
        final Consumer<Subscription> consumer;

        SubscriptionEvent(String desc) {
            this(null, desc);
        }

        SubscriptionEvent(Consumer<Subscription> consumer, String desc) {
            super(desc);
            this.consumer = consumer;
        }

        void consume(Subscription subscription) {
            if (this.consumer != null) {
                this.consumer.accept(subscription);
            }
        }

        boolean isTerminal() {
            return this.consumer == null;
        }
    }

    static abstract class AbstractEagerEvent<T>
    implements EagerEvent<T> {
        String description = "";

        public AbstractEagerEvent(String description) {
            this.description = description;
        }

        @Override
        public boolean setDescription(String description) {
            this.description = description;
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static interface EagerEvent<T>
    extends Event<T> {
    }

    static final class DefaultVerifySubscriber<T>
    implements StepVerifier,
    Subscriber<T>,
    Trackable,
    Receiver {
        final AtomicReference<Subscription> subscription;
        final CountDownLatch completeLatch;
        final Queue<Event<T>> script;
        final Queue<TaskEvent<T>> taskEvents;
        final int requestedFusionMode;
        final int expectedFusionMode;
        final long initialRequest;
        final VirtualTimeScheduler virtualTimeScheduler;
        Logger logger;
        int establishedFusionMode;
        Fuseable.QueueSubscription<T> qs;
        long produced;
        long unasserted;
        volatile long requested;
        Iterator<? extends T> currentNextAs;
        Collection<T> currentCollector;
        static final AtomicLongFieldUpdater<DefaultVerifySubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(DefaultVerifySubscriber.class, "requested");
        volatile int wip;
        volatile Throwable errors;
        volatile boolean monitorSignal;

        DefaultVerifySubscriber(List<Event<T>> script, long initialRequest, int requestedFusionMode, int expectedFusionMode, boolean debugEnabled, VirtualTimeScheduler vts) {
            Event<T> event;
            this.virtualTimeScheduler = vts;
            this.requestedFusionMode = requestedFusionMode;
            this.expectedFusionMode = expectedFusionMode;
            this.initialRequest = initialRequest;
            this.logger = debugEnabled ? Loggers.getLogger(StepVerifier.class) : null;
            this.script = DefaultVerifySubscriber.conflateScript(script, this.logger);
            this.taskEvents = new ConcurrentLinkedQueue<TaskEvent<T>>();
            while ((event = this.script.peek()) instanceof TaskEvent) {
                this.taskEvents.add((TaskEvent)this.script.poll());
            }
            this.monitorSignal = this.taskEvents.peek() instanceof NoEvent;
            this.produced = 0L;
            this.unasserted = 0L;
            this.completeLatch = new CountDownLatch(1);
            this.subscription = new AtomicReference();
            this.requested = initialRequest;
        }

        static <R> Queue<Event<R>> conflateScript(List<Event<R>> script, Logger logger) {
            Event<R> event;
            ConcurrentLinkedQueue<Event<R>> queue = new ConcurrentLinkedQueue<Event<R>>(script);
            ConcurrentLinkedQueue<Event<R>> conflated = new ConcurrentLinkedQueue<Event<Object>>();
            while ((event = queue.peek()) != null) {
                if (event instanceof TaskEvent) {
                    conflated.add(queue.poll());
                    while (queue.peek() instanceof SubscriptionEvent) {
                        conflated.add(new SubscriptionTaskEvent((SubscriptionEvent)queue.poll()));
                    }
                    continue;
                }
                conflated.add(queue.poll());
            }
            Iterator iterator = conflated.iterator();
            Event previous = null;
            while (iterator.hasNext()) {
                Event current = (Event)iterator.next();
                if (previous != null && current instanceof DescriptionEvent) {
                    String newDescription = current.getDescription();
                    String oldDescription = previous.getDescription();
                    boolean applied = previous.setDescription(newDescription);
                    if (logger != null && applied) {
                        logger.debug("expectation <{}> now described as <{}>", new Object[]{oldDescription, newDescription});
                    }
                }
                previous = current;
            }
            queue.clear();
            queue.addAll(conflated.stream().filter(ev -> !(ev instanceof DescriptionEvent)).collect(Collectors.toList()));
            conflated = queue;
            if (logger != null) {
                logger.debug("Scenario:");
                for (Event<R> current : conflated) {
                    logger.debug("\t<{}>", new Object[]{current.getDescription()});
                }
            }
            return conflated;
        }

        public VirtualTimeScheduler virtualTimeScheduler() {
            return this.virtualTimeScheduler;
        }

        public Throwable getError() {
            return this.errors;
        }

        public boolean isCancelled() {
            return this.upstream() == Operators.cancelledSubscription();
        }

        public boolean isStarted() {
            return this.upstream() != null;
        }

        public boolean isTerminated() {
            return this.completeLatch.getCount() == 0L;
        }

        public void onComplete() {
            this.onExpectation(Signal.complete());
            this.completeLatch.countDown();
        }

        public void onError(Throwable t) {
            this.onExpectation(Signal.error((Throwable)t));
            this.completeLatch.countDown();
        }

        public void onNext(T t) {
            block8: {
                Signal signal;
                if (this.establishedFusionMode == 2) {
                    while (true) {
                        block7: {
                            ++this.produced;
                            ++this.unasserted;
                            try {
                                t = this.qs.poll();
                                if (t != null) break block7;
                                break block8;
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal((Throwable)e);
                                this.onExpectation(Signal.error((Throwable)e));
                                this.cancel();
                                this.completeLatch.countDown();
                                return;
                            }
                        }
                        if (this.currentCollector != null) {
                            this.currentCollector.add(t);
                        }
                        this.onExpectation(Signal.next(t));
                    }
                }
                ++this.produced;
                ++this.unasserted;
                if (this.currentCollector != null) {
                    this.currentCollector.add(t);
                }
                if (!this.checkRequestOverflow(signal = Signal.next(t))) {
                    this.onExpectation(signal);
                }
            }
        }

        public void onSubscribe(Subscription subscription) {
            if (subscription == null) {
                throw Exceptions.argumentIsNullException();
            }
            if (this.subscription.compareAndSet(null, subscription)) {
                this.onExpectation(Signal.subscribe((Subscription)subscription));
                if (this.requestedFusionMode >= 0) {
                    this.startFusion(subscription);
                } else if (this.initialRequest != 0L) {
                    subscription.request(this.initialRequest);
                }
            } else {
                subscription.cancel();
                if (this.isCancelled()) {
                    this.setFailure(null, "an unexpected Subscription has been received: %s; actual: cancelled", subscription);
                } else {
                    this.setFailure(null, "an unexpected Subscription has been received: %s; actual: ", subscription, this.subscription);
                }
            }
        }

        public Subscription upstream() {
            return this.subscription.get();
        }

        @Override
        public DefaultVerifySubscriber<T> log() {
            if (this.logger == null) {
                this.logger = Loggers.getLogger(StepVerifier.class);
            }
            return this;
        }

        @Override
        public Duration verify() {
            return this.verify(Duration.ZERO);
        }

        @Override
        public Duration verify(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            Instant now = Instant.now();
            try {
                this.pollTaskEventOrComplete(duration);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.validate();
            return Duration.between(now, Instant.now());
        }

        final void setFailure(Event<T> event, String msg, Object ... arguments) {
            this.setFailure(event, null, msg, arguments);
        }

        final void setFailure(Event<T> event, Signal<T> actualSignal, String msg, Object ... arguments) {
            Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.fail(event, msg, arguments).get())));
            this.maybeCancel(actualSignal);
            this.completeLatch.countDown();
        }

        final void setFailurePrefix(String prefix, Signal<T> actualSignal, String msg, Object ... arguments) {
            Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.failPrefix(prefix, msg, arguments).get())));
            this.maybeCancel(actualSignal);
            this.completeLatch.countDown();
        }

        final Subscription cancel() {
            Subscription s = this.subscription.getAndSet(Operators.cancelledSubscription());
            if (s != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
            return s;
        }

        final void maybeCancel(Signal<T> actualSignal) {
            if (actualSignal == null || !actualSignal.isOnComplete() && !actualSignal.isOnError()) {
                this.cancel();
            }
        }

        final Optional<AssertionError> checkCountMismatch(SignalCountEvent<T> event, Signal<T> s) {
            long expected = event.count;
            if (!s.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(event, "expected: count = %s; actual: counted = %s; signal: %s", expected, this.unasserted, s);
            }
            return Optional.empty();
        }

        final boolean checkRequestOverflow(Signal<T> s) {
            long r = this.requested;
            if (!s.isOnNext() || r < 0L || r == Long.MAX_VALUE || r >= this.produced) {
                return false;
            }
            this.setFailurePrefix("request overflow (", s, "expected production of at most %s; produced: %s; request overflown by signal: %s", r, this.produced, s);
            return true;
        }

        boolean onCollect(Signal<T> actualSignal) {
            CollectEvent collectEvent = (CollectEvent)this.script.poll();
            if (collectEvent.supplier != null) {
                Collection c = collectEvent.get();
                this.currentCollector = c;
                if (c == null) {
                    this.setFailure(collectEvent, actualSignal, "expected collection; actual supplied is [null]", new Object[0]);
                }
                return true;
            }
            Collection<T> c = this.currentCollector;
            if (c == null) {
                this.setFailure(collectEvent, actualSignal, "expected record collector; actual record is [null]", new Object[0]);
                return true;
            }
            Optional<AssertionError> error = collectEvent.test(c);
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
                return true;
            }
            return true;
        }

        final void onExpectation(Signal<T> actualSignal) {
            if (this.monitorSignal) {
                this.setFailure(null, actualSignal, "expected no event: %s", actualSignal);
                return;
            }
            try {
                Event<T> event = this.script.peek();
                if (event == null) {
                    this.setFailure(null, actualSignal, "did not expect: %s", actualSignal);
                    return;
                }
                this.onTaskEvent();
                if (event instanceof SignalConsumeWhileEvent) {
                    if (this.consumeWhile(actualSignal, (SignalConsumeWhileEvent)event)) {
                        return;
                    }
                    event = this.script.peek();
                }
                if (event instanceof SignalCountEvent ? this.onSignalCount(actualSignal, (SignalCountEvent)event) : (event instanceof CollectEvent ? this.onCollect(actualSignal) : (event instanceof SignalSequenceEvent ? this.onSignalSequence(actualSignal, (SignalSequenceEvent)event) : event instanceof SignalEvent && this.onSignal(actualSignal)))) {
                    return;
                }
                event = this.script.peek();
                if (event == null || !(event instanceof EagerEvent)) {
                    return;
                }
                while (event != null && event instanceof EagerEvent) {
                    if (event instanceof SubscriptionEvent) {
                        if (this.onSubscription()) {
                            return;
                        }
                    } else if (event instanceof CollectEvent) {
                        if (this.onCollect(actualSignal)) {
                            return;
                        }
                    } else {
                        this.onTaskEvent();
                    }
                    event = this.script.peek();
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                if (e instanceof AssertionError) {
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)e);
                } else {
                    String msg = e.getMessage() != null ? e.getMessage() : "";
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.fail(null, "failed running expectation on signal [%s] with [%s]:\n%s", actualSignal, Exceptions.unwrap((Throwable)e).getClass().getName(), msg).get())));
                }
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
            }
        }

        boolean onSignal(Signal<T> actualSignal) {
            SignalEvent signalEvent = (SignalEvent)this.script.poll();
            Optional<AssertionError> error = signalEvent.test(actualSignal);
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                if (actualSignal.isOnError()) {
                    ((Throwable)((Object)error.get())).addSuppressed(actualSignal.getThrowable());
                }
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
                return true;
            }
            if (actualSignal.isOnNext()) {
                --this.unasserted;
            }
            return false;
        }

        boolean onSignalSequence(Signal<T> actualSignal, SignalSequenceEvent<T> sequenceEvent) {
            Optional<AssertionError> error;
            Iterator<T> currentNextAs = this.currentNextAs;
            if (actualSignal.isOnNext() && currentNextAs == null) {
                currentNextAs = sequenceEvent.iterable.iterator();
                this.currentNextAs = currentNextAs;
            }
            if ((error = sequenceEvent.test(actualSignal, currentNextAs)) == EXPECT_MORE) {
                if (actualSignal.isOnNext()) {
                    --this.unasserted;
                }
                return false;
            }
            if (!error.isPresent()) {
                this.currentNextAs = null;
                this.script.poll();
                if (actualSignal.isOnNext()) {
                    --this.unasserted;
                }
            } else {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                if (actualSignal.isOnError()) {
                    ((Throwable)((Object)error.get())).addSuppressed(actualSignal.getThrowable());
                }
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
                return true;
            }
            return false;
        }

        boolean consumeWhile(Signal<T> actualSignal, SignalConsumeWhileEvent<T> whileEvent) {
            if (actualSignal.isOnNext() && whileEvent.test(actualSignal.get())) {
                --this.unasserted;
                if (this.logger != null) {
                    this.logger.debug("{} consumed {}", new Object[]{whileEvent.getDescription(), actualSignal});
                }
                return true;
            }
            if (this.logger != null) {
                this.logger.debug("{} stopped at {}", new Object[]{whileEvent.getDescription(), actualSignal});
            }
            this.script.poll();
            return false;
        }

        final boolean onSignalCount(Signal<T> actualSignal, SignalCountEvent<T> event) {
            if (this.unasserted >= event.count) {
                this.script.poll();
                this.unasserted -= event.count;
            } else {
                Optional<AssertionError> error;
                if (event.count != 0L && (error = this.checkCountMismatch(event, actualSignal)).isPresent()) {
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                    if (actualSignal.isOnError()) {
                        ((Throwable)((Object)error.get())).addSuppressed(actualSignal.getThrowable());
                    }
                    this.maybeCancel(actualSignal);
                    this.completeLatch.countDown();
                }
                return true;
            }
            return false;
        }

        void onTaskEvent() {
            while (true) {
                if (this.isCancelled()) {
                    return;
                }
                Event<T> event = this.script.peek();
                if (!(event instanceof TaskEvent)) break;
                event = this.script.poll();
                if (!(event instanceof TaskEvent)) {
                    return;
                }
                this.taskEvents.add((TaskEvent)event);
            }
        }

        boolean onSubscription() {
            int missed = WIP.incrementAndGet(this);
            if (missed != 1) {
                return true;
            }
            do {
                if (!(this.script.peek() instanceof SubscriptionEvent)) continue;
                SubscriptionEvent subscriptionEvent = (SubscriptionEvent)this.script.poll();
                if (subscriptionEvent instanceof RequestEvent) {
                    this.updateRequested(subscriptionEvent);
                }
                if (subscriptionEvent.isTerminal()) {
                    this.doCancel();
                    return true;
                }
                subscriptionEvent.consume(this.upstream());
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            return false;
        }

        void doCancel() {
            this.cancel();
            this.completeLatch.countDown();
        }

        final void pollTaskEventOrComplete(Duration timeout) throws InterruptedException {
            block8: {
                Objects.requireNonNull(timeout, "timeout");
                Instant stop = Instant.now().plus(timeout);
                boolean skip = true;
                while (true) {
                    Event<T> event;
                    if ((event = (Event<T>)this.taskEvents.poll()) != null) {
                        try {
                            skip = false;
                            if (event instanceof SubscriptionTaskEvent) {
                                this.updateRequested(event);
                            }
                            ((TaskEvent)event).run(this);
                        }
                        catch (Throwable t) {
                            Exceptions.throwIfFatal((Throwable)t);
                            this.cancel();
                            if (t instanceof AssertionError) {
                                throw (AssertionError)((Object)t);
                            }
                            throw Exceptions.propagate((Throwable)t);
                        }
                    }
                    if (!skip && (event = this.script.peek()) instanceof SubscriptionEvent) {
                        this.onSubscription();
                    }
                    if (this.completeLatch.await(10L, TimeUnit.NANOSECONDS)) break block8;
                    if (timeout != Duration.ZERO && stop.isBefore(Instant.now())) break;
                }
                if (!this.isStarted()) {
                    throw new IllegalStateException("VerifySubscriber has not been subscribed");
                }
                throw new AssertionError((Object)("VerifySubscriber timed out on " + this.upstream()));
            }
        }

        private void updateRequested(Event<?> event) {
            RequestEvent requestEvent = null;
            if (event instanceof RequestEvent) {
                requestEvent = (RequestEvent)event;
            } else if (event instanceof SubscriptionTaskEvent) {
                SubscriptionTaskEvent ste = (SubscriptionTaskEvent)event;
                if (ste.delegate instanceof RequestEvent) {
                    requestEvent = (RequestEvent)ste.delegate;
                }
            }
            if (requestEvent == null) {
                return;
            }
            if (requestEvent.isBounded()) {
                Operators.addAndGet(REQUESTED, (Object)this, (long)requestEvent.getRequestAmount());
            } else {
                REQUESTED.set(this, Long.MAX_VALUE);
            }
        }

        final void startFusion(Subscription s) {
            block14: {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs;
                    this.qs = qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(this.requestedFusionMode);
                    if (this.expectedFusionMode == 0 && m != 0) {
                        this.setFailure(null, "expected no fusion; actual: %s", DefaultStepVerifierBuilder.formatFusionMode(m));
                        return;
                    }
                    if (this.expectedFusionMode != 0 && m == 0) {
                        this.setFailure(null, "expected fusion: %s; actual does not support fusion", DefaultStepVerifierBuilder.formatFusionMode(this.expectedFusionMode));
                        return;
                    }
                    if ((m & this.expectedFusionMode) != m) {
                        this.setFailure(null, "expected fusion mode: %s; actual: %s", DefaultStepVerifierBuilder.formatFusionMode(this.expectedFusionMode), DefaultStepVerifierBuilder.formatFusionMode(m));
                        return;
                    }
                    this.establishedFusionMode = m;
                    if (m == 1) {
                        while (true) {
                            Object v;
                            try {
                                v = qs.poll();
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal((Throwable)e);
                                this.onExpectation(Signal.error((Throwable)e));
                                return;
                            }
                            if (v == null) {
                                this.onComplete();
                                break block14;
                            }
                            this.onNext(v);
                        }
                    }
                    if (this.initialRequest != 0L) {
                        s.request(this.initialRequest);
                    }
                } else if (this.expectedFusionMode != 0) {
                    this.setFailure(null, "expected fuseable source but actual Subscription is not: %s", this.expectedFusionMode, s);
                } else if (this.initialRequest != 0L) {
                    s.request(this.initialRequest);
                }
            }
        }

        final void validate() {
            if (!this.isStarted()) {
                throw new IllegalStateException("VerifySubscriber has not been subscribed");
            }
            Throwable errors = this.errors;
            if (errors == null) {
                return;
            }
            if (errors instanceof AssertionError) {
                throw (AssertionError)((Object)errors);
            }
            ArrayList<Throwable> flat = new ArrayList<Throwable>();
            flat.add(errors);
            flat.addAll(Arrays.asList(errors.getSuppressed()));
            StringBuilder messageBuilder = new StringBuilder("Expectation failure(s):\n");
            flat.stream().flatMap(error -> Stream.of(" - ", error, "\n")).forEach(messageBuilder::append);
            messageBuilder.delete(messageBuilder.length() - 1, messageBuilder.length());
            throw new AssertionError(messageBuilder.toString(), errors);
        }
    }

    static final class DefaultStepVerifier<T>
    implements StepVerifier {
        private final DefaultStepVerifierBuilder<T> parent;
        private final int requestedFusionMode;
        private final int expectedFusionMode;
        private boolean debugEnabled;

        DefaultStepVerifier(DefaultStepVerifierBuilder<T> parent) {
            this.parent = parent;
            this.requestedFusionMode = parent.requestedFusionMode;
            this.expectedFusionMode = parent.expectedFusionMode == -1 ? parent.requestedFusionMode : parent.expectedFusionMode;
        }

        @Override
        public DefaultStepVerifier<T> log() {
            this.debugEnabled = true;
            return this;
        }

        @Override
        public Duration verify() {
            return this.verify(Duration.ZERO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration verify(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            if (this.parent.sourceSupplier != null) {
                VirtualTimeScheduler vts = null;
                if (this.parent.vtsLookup != null) {
                    vts = this.parent.vtsLookup.get();
                    VirtualTimeScheduler.enable(vts);
                }
                try {
                    Publisher publisher = this.parent.sourceSupplier.get();
                    Instant now = Instant.now();
                    DefaultVerifySubscriber newVerifier = new DefaultVerifySubscriber(this.parent.script, this.parent.initialRequest, this.requestedFusionMode, this.expectedFusionMode, this.debugEnabled, vts);
                    publisher.subscribe(newVerifier);
                    newVerifier.verify(duration);
                    Duration duration2 = Duration.between(now, Instant.now());
                    return duration2;
                }
                finally {
                    if (vts != null) {
                        vts.shutdown();
                    }
                }
            }
            return this.toSubscriber().verify(duration);
        }

        DefaultVerifySubscriber<T> toSubscriber() {
            VirtualTimeScheduler vts = null;
            if (this.parent.vtsLookup != null) {
                vts = this.parent.vtsLookup.get();
            }
            return new DefaultVerifySubscriber(this.parent.script, this.parent.initialRequest, this.requestedFusionMode, this.expectedFusionMode, this.debugEnabled, vts);
        }
    }

    static interface Event<T> {
        public boolean setDescription(String var1);

        public String getDescription();
    }
}

