/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.v1_0;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Marker;

final class LoggingEventWrapper
implements ILoggingEvent {
    private final ILoggingEvent event;
    private final Map<String, String> mdcPropertyMap;
    @Nullable
    private final LoggerContextVO vo;

    LoggingEventWrapper(ILoggingEvent event, Map<String, String> mdcPropertyMap) {
        this.event = event;
        this.mdcPropertyMap = mdcPropertyMap;
        LoggerContextVO oldVo = event.getLoggerContextVO();
        this.vo = oldVo != null ? new LoggerContextVO(oldVo.getName(), mdcPropertyMap, oldVo.getBirthTime()) : null;
    }

    public Object[] getArgumentArray() {
        return this.event.getArgumentArray();
    }

    public Level getLevel() {
        return this.event.getLevel();
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public IThrowableProxy getThrowableProxy() {
        return this.event.getThrowableProxy();
    }

    public void prepareForDeferredProcessing() {
        this.event.prepareForDeferredProcessing();
    }

    public LoggerContextVO getLoggerContextVO() {
        return this.vo;
    }

    public String getMessage() {
        return this.event.getMessage();
    }

    public long getTimeStamp() {
        return this.event.getTimeStamp();
    }

    public StackTraceElement[] getCallerData() {
        return this.event.getCallerData();
    }

    public boolean hasCallerData() {
        return this.event.hasCallerData();
    }

    public Marker getMarker() {
        return this.event.getMarker();
    }

    public String getFormattedMessage() {
        return this.event.getFormattedMessage();
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    @Deprecated
    public Map<String, String> getMdc() {
        return this.event.getMDCPropertyMap();
    }

    public String toString() {
        return this.event.toString();
    }
}

